/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.wf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.local.Accept;
import org.scribble.model.local.Connect;
import org.scribble.model.local.Disconnect;
import org.scribble.model.local.EndpointFSM;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.model.local.Receive;
import org.scribble.model.local.Send;
import org.scribble.model.local.WrapClient;
import org.scribble.model.local.WrapServer;
import org.scribble.model.wf.WFBuffers;
import org.scribble.sesstype.name.Role;

public class WFConfig {
    public final Map<Role, EndpointFSM> states;
    public final WFBuffers buffs;

    public WFConfig(Map<Role, EndpointFSM> state, WFBuffers buffs) {
        this.states = Collections.unmodifiableMap(state);
        this.buffs = buffs;
    }

    public boolean isSafeTermination() {
        for (Role r : this.states.keySet()) {
            if (this.canSafelyTerminate(r)) continue;
            return false;
        }
        return true;
    }

    public boolean canSafelyTerminate(Role r) {
        EndpointFSM s = this.states.get(r);
        return (!s.isTerminal() || this.buffs.isEmpty(r)) && (s.isTerminal() || s.getStateKind().equals((Object)EndpointState.Kind.ACCEPT) && s.isInitial() && !this.states.keySet().stream().anyMatch(rr -> !r.equals(rr) && this.buffs.isConnected(r, (Role)rr)));
    }

    public List<WFConfig> take(Role r, IOAction a) {
        LinkedList<WFConfig> res = new LinkedList<WFConfig>();
        List<EndpointFSM> succs = this.states.get(r).takeAll(a);
        for (EndpointFSM succ : succs) {
            WFBuffers tmp2;
            HashMap<Role, EndpointFSM> tmp1 = new HashMap<Role, EndpointFSM>(this.states);
            tmp1.put(r, succ);
            WFBuffers wFBuffers = a.isSend() ? this.buffs.send(r, (Send)a) : (a.isReceive() ? this.buffs.receive(r, (Receive)a) : (tmp2 = a.isDisconnect() ? this.buffs.disconnect(r, (Disconnect)a) : null));
            if (tmp2 == null) {
                throw new RuntimeException("Shouldn't get in here: " + a);
            }
            res.add(new WFConfig(tmp1, tmp2));
        }
        return res;
    }

    public List<WFConfig> sync(Role r1, IOAction a1, Role r2, IOAction a2) {
        LinkedList<WFConfig> res = new LinkedList<WFConfig>();
        List<EndpointFSM> succs1 = this.states.get(r1).takeAll(a1);
        List<EndpointFSM> succs2 = this.states.get(r2).takeAll(a2);
        for (EndpointFSM succ1 : succs1) {
            for (EndpointFSM succ2 : succs2) {
                WFBuffers tmp2;
                HashMap<Role, EndpointFSM> tmp1 = new HashMap<Role, EndpointFSM>(this.states);
                tmp1.put(r1, succ1);
                tmp1.put(r2, succ2);
                if (a1.isConnect() && a2.isAccept() || a1.isAccept() && a2.isConnect()) {
                    tmp2 = this.buffs.connect(r1, r2);
                } else if (a1.isWrapClient() && a2.isWrapServer() || a1.isWrapServer() && a2.isWrapClient()) {
                    tmp2 = this.buffs;
                } else {
                    throw new RuntimeException("Shouldn't get in here: " + a1 + ", " + a2);
                }
                res.add(new WFConfig(tmp1, tmp2));
            }
        }
        return res;
    }

    public Map<Role, Receive> getStuckMessages() {
        HashMap<Role, Receive> res = new HashMap<Role, Receive>();
        for (Role r : this.states.keySet()) {
            Receive recv;
            EndpointFSM s = this.states.get(r);
            EndpointState.Kind k = s.getStateKind();
            if (k != EndpointState.Kind.UNARY_INPUT && k != EndpointState.Kind.POLY_INPUT) continue;
            Role peer = s.getAllTakeable().iterator().next().peer;
            Send send = this.buffs.get(r).get(peer);
            if (send == null || s.isTakeable(recv = send.toDual(peer))) continue;
            res.put(r, recv);
        }
        return res;
    }

    public Set<Set<Role>> getWaitForErrors() {
        HashSet<Set<Role>> res = new HashSet<Set<Role>>();
        LinkedList<Role> todo = new LinkedList<Role>(this.states.keySet());
        while (!todo.isEmpty()) {
            Set<Role> cycle;
            Role r = (Role)todo.remove(0);
            if (this.states.get(r).isTerminal() || (cycle = this.isWaitForChain(r)) == null) continue;
            todo.removeAll(cycle);
            res.add(cycle);
        }
        return res;
    }

    public Set<Role> isWaitForChain(Role orig) {
        LinkedHashSet<Role> candidate = new LinkedHashSet<Role>();
        LinkedHashSet<Role> todo = new LinkedHashSet<Role>(Arrays.asList(orig));
        while (!todo.isEmpty()) {
            Role r = (Role)todo.iterator().next();
            todo.remove(r);
            candidate.add(r);
            EndpointFSM s = this.states.get(r);
            if (s.getStateKind() == EndpointState.Kind.OUTPUT && !s.isConnectOrWrapClientOnly()) {
                return null;
            }
            if (s.isTerminal()) {
                if (!todo.isEmpty()) continue;
                return candidate;
            }
            Set<Role> blocked = this.isWaitingFor(r);
            if (blocked == null) {
                return null;
            }
            if (todo.isEmpty() && candidate.containsAll(blocked)) {
                return candidate;
            }
            blocked.forEach(x -> {
                if (!candidate.contains(x)) {
                    todo.add((Role)x);
                }
            });
        }
        return null;
    }

    private Set<Role> isWaitingFor(Role r) {
        EndpointFSM s = this.states.get(r);
        EndpointState.Kind k = s.getStateKind();
        if (k == EndpointState.Kind.UNARY_INPUT || k == EndpointState.Kind.POLY_INPUT) {
            Set<Role> peers;
            List<IOAction> all = s.getAllTakeable();
            IOAction a = all.get(0);
            if (a.isReceive() && (peers = all.stream().map(x -> x.peer).collect(Collectors.toSet())).stream().noneMatch(p -> this.buffs.get(r).get(p) != null)) {
                return peers;
            }
        } else if (k == EndpointState.Kind.ACCEPT) {
            if (!s.isInitial()) {
                List<IOAction> all = s.getAllTakeable();
                HashSet<Role> res = new HashSet<Role>();
                for (IOAction a : all) {
                    if (this.states.get(a.peer).getAllTakeable().contains(a.toDual(r))) {
                        return null;
                    }
                    res.add(a.peer);
                }
                if (!res.isEmpty()) {
                    return res;
                }
            }
        } else if (k == EndpointState.Kind.OUTPUT && s.isConnectOrWrapClientOnly()) {
            List<IOAction> all = s.getAllTakeable();
            HashSet<Role> res = new HashSet<Role>();
            for (IOAction a : all) {
                if (this.states.get(a.peer).getAllTakeable().contains(a.toDual(r))) {
                    return null;
                }
                res.add(a.peer);
            }
            if (!res.isEmpty()) {
                return res;
            }
        }
        return null;
    }

    public Map<Role, Set<Send>> getOrphanMessages() {
        HashMap<Role, Set<Send>> res = new HashMap<Role, Set<Send>>();
        for (Role r : this.states.keySet()) {
            EndpointFSM s = this.states.get(r);
            if (s.isTerminal()) {
                Set orphs = this.buffs.get(r).values().stream().filter(v -> v != null).collect(Collectors.toSet());
                if (orphs.isEmpty()) continue;
                HashSet tmp = (HashSet)res.get(r);
                if (tmp == null) {
                    tmp = new HashSet();
                    res.put(r, tmp);
                }
                tmp.addAll(orphs);
                continue;
            }
            this.states.keySet().forEach(rr -> {
                Send send;
                if (!rr.equals(r) && !this.buffs.isConnected(r, (Role)rr) && (send = this.buffs.get(r).get(rr)) != null) {
                    HashSet<Send> tmp = (HashSet<Send>)res.get(r);
                    if (tmp == null) {
                        tmp = new HashSet<Send>();
                        res.put(r, tmp);
                    }
                    tmp.add(send);
                }
            });
        }
        return res;
    }

    public Map<Role, List<IOAction>> getTakeable() {
        HashMap<Role, List<IOAction>> res = new HashMap<Role, List<IOAction>>();
        block7: for (Role r : this.states.keySet()) {
            EndpointFSM fsm = this.states.get(r);
            switch (fsm.getStateKind()) {
                case OUTPUT: {
                    List<IOAction> as = fsm.getAllTakeable();
                    for (IOAction a : as) {
                        List<IOAction> tmp;
                        List<IOAction> peeras;
                        EndpointFSM speer;
                        List<IOAction> tmp2;
                        if (a.isSend()) {
                            if (!this.buffs.canSend(r, (Send)a)) continue;
                            tmp2 = (LinkedList<IOAction>)res.get(r);
                            if (tmp2 == null) {
                                tmp2 = new LinkedList<IOAction>();
                                res.put(r, tmp2);
                            }
                            tmp2.add(a);
                            continue;
                        }
                        if (a.isConnect()) {
                            Connect c = (Connect)a;
                            speer = this.states.get(c.peer);
                            peeras = speer.getAllTakeable();
                            for (IOAction peera : peeras) {
                                if (!peera.equals(c.toDual(r)) || !this.buffs.canConnect(r, c)) continue;
                                tmp = (LinkedList<IOAction>)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList<IOAction>();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        if (a.isDisconnect()) {
                            if (!this.buffs.canDisconnect(r, (Disconnect)a)) continue;
                            tmp2 = (List)res.get(r);
                            if (tmp2 == null) {
                                tmp2 = new LinkedList();
                                res.put(r, tmp2);
                            }
                            tmp2.add(a);
                            continue;
                        }
                        if (a.isWrapClient()) {
                            WrapClient wc = (WrapClient)a;
                            speer = this.states.get(wc.peer);
                            peeras = speer.getAllTakeable();
                            for (IOAction peera : peeras) {
                                if (!peera.equals(wc.toDual(r)) || !this.buffs.canWrapClient(r, wc)) continue;
                                tmp = (List)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case UNARY_INPUT: 
                case POLY_INPUT: {
                    for (IOAction a : this.buffs.inputable(r)) {
                        if (a.isReceive()) {
                            if (!fsm.isTakeable(a)) continue;
                            LinkedList<IOAction> tmp = (LinkedList<IOAction>)res.get(r);
                            if (tmp == null) {
                                tmp = new LinkedList<IOAction>();
                                res.put(r, tmp);
                            }
                            tmp.add(a);
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case TERMINAL: {
                    break;
                }
                case ACCEPT: {
                    List<IOAction> tmp;
                    List<IOAction> peeras;
                    EndpointFSM speer;
                    for (IOAction a : this.buffs.acceptable(r, fsm.curr)) {
                        if (a.isAccept()) {
                            Accept c = (Accept)a;
                            speer = this.states.get(c.peer);
                            peeras = speer.getAllTakeable();
                            for (IOAction peera : peeras) {
                                if (!peera.equals(c.toDual(r)) || !this.buffs.canAccept(r, c)) continue;
                                tmp = (List)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                case WRAP_SERVER: {
                    List<IOAction> tmp;
                    List<IOAction> peeras;
                    EndpointFSM speer;
                    for (IOAction a : this.buffs.wrapable(r)) {
                        if (a.isWrapServer()) {
                            WrapServer ws = (WrapServer)a;
                            speer = this.states.get(ws.peer);
                            peeras = speer.getAllTakeable();
                            for (IOAction peera : peeras) {
                                if (!peera.equals(ws.toDual(r)) || !this.buffs.canWrapServer(r, ws)) continue;
                                tmp = (LinkedList<IOAction>)res.get(r);
                                if (tmp == null) {
                                    tmp = new LinkedList<IOAction>();
                                    res.put(r, tmp);
                                }
                                tmp.add(a);
                            }
                            continue;
                        }
                        throw new RuntimeException("Shouldn't get in here: " + a);
                    }
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Shouldn't get in here: " + fsm);
                }
            }
        }
        return res;
    }

    public final int hashCode() {
        int hash = 71;
        hash = 31 * hash + this.states.hashCode();
        hash = 31 * hash + this.buffs.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WFConfig)) {
            return false;
        }
        WFConfig c = (WFConfig)o;
        return this.states.equals(c.states) && this.buffs.equals(c.buffs);
    }

    public String toString() {
        return "(" + this.states + ", " + this.buffs + ")";
    }
}

