/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.wf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scribble.model.global.GIOAction;
import org.scribble.model.local.IOAction;
import org.scribble.model.local.Receive;
import org.scribble.model.local.Send;
import org.scribble.model.wf.WFConfig;
import org.scribble.model.wf.WFStateErrors;
import org.scribble.sesstype.name.Role;

public class WFState {
    private static int count = 0;
    public final int id = count++;
    public final WFConfig config;
    protected final List<GIOAction> actions;
    protected final List<WFState> succs;

    public WFState(WFConfig config) {
        this.config = config;
        this.actions = new LinkedList<GIOAction>();
        this.succs = new LinkedList<WFState>();
    }

    public void addEdge(GIOAction a, WFState s) {
        Iterator<GIOAction> as = this.actions.iterator();
        Iterator<WFState> ss = this.succs.iterator();
        while (as.hasNext()) {
            GIOAction tmpa = as.next();
            WFState tmps = ss.next();
            if (!tmpa.equals(a) || !tmps.equals(s)) continue;
            return;
        }
        this.actions.add(a);
        this.succs.add(s);
    }

    public List<GIOAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public Map<Role, List<IOAction>> getTakeable() {
        return this.config.getTakeable();
    }

    public List<WFConfig> take(Role r, IOAction a) {
        return this.config.take(r, a);
    }

    public List<WFConfig> sync(Role r1, IOAction a1, Role r2, IOAction a2) {
        return this.config.sync(r1, a1, r2, a2);
    }

    public List<WFState> getSuccessors() {
        return Collections.unmodifiableList(this.succs);
    }

    public boolean isError() {
        return this.isTerminal() && !this.config.isSafeTermination();
    }

    public WFStateErrors getErrors() {
        Map<Role, Receive> stuck = this.config.getStuckMessages();
        Set<Set<Role>> waitfor = this.config.getWaitForErrors();
        Map<Role, Set<Send>> orphs = this.config.getOrphanMessages();
        return new WFStateErrors(stuck, waitfor, orphs);
    }

    public boolean isTerminal() {
        return this.actions.isEmpty();
    }

    public final int hashCode() {
        int hash = 73;
        hash = 31 * hash + this.config.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WFState)) {
            return false;
        }
        return this.config.equals(((WFState)o).config);
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.config.toString();
    }

    public final String toDot() {
        String s = "digraph G {\ncompound = true;\n";
        s = String.valueOf(s) + this.toDot(new HashSet<WFState>());
        return String.valueOf(s) + "\n}";
    }

    protected final String toDot(Set<WFState> seen) {
        seen.add(this);
        String s = this.toNodeDot();
        int i = 0;
        while (i < this.actions.size()) {
            GIOAction msg = this.actions.get(i);
            WFState p = this.succs.get(i);
            s = String.valueOf(s) + "\n" + this.toEdgeDot(msg, p);
            if (!seen.contains(p)) {
                s = String.valueOf(s) + "\n" + p.toDot(seen);
            }
            ++i;
        }
        return s;
    }

    protected final String toEdgeDot(String src, String dest, String lab) {
        return String.valueOf(src) + " -> " + dest + " [ " + lab + " ];";
    }

    protected String toNodeDot() {
        return String.valueOf(this.getDotNodeId()) + " [ " + this.getNodeLabel() + " ];";
    }

    protected String getNodeLabel() {
        String labs = this.config.toString();
        return "label=\"" + this.id + ":" + labs.substring(1, labs.length() - 1) + "\"";
    }

    protected String getDotNodeId() {
        return "\"" + this.id + "\"";
    }

    protected String toEdgeDot(GIOAction msg, WFState next) {
        return this.toEdgeDot(this.getDotNodeId(), next.getDotNodeId(), next.getEdgeLabel(msg));
    }

    protected String getEdgeLabel(GIOAction msg) {
        return "label=\"" + msg + "\"";
    }
}

