/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.scribsock;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import org.scribble.main.ScribbleRuntimeException;
import org.scribble.net.ScribMessage;
import org.scribble.net.scribsock.LinearSocket;
import org.scribble.net.session.BinaryChannelEndpoint;
import org.scribble.net.session.Session;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.sesstype.name.Op;
import org.scribble.sesstype.name.Role;

public abstract class OutputSocket<S extends Session, R extends Role>
extends LinearSocket<S, R> {
    protected OutputSocket(SessionEndpoint<S, R> ep) {
        super(ep);
    }

    protected void writeScribMessage(Role peer, Op op, Object ... payload) throws IOException, ScribbleRuntimeException {
        this.writeScribMessage(peer, new ScribMessage(op, payload));
    }

    protected void writeScribMessage(Role peer, ScribMessage msg) throws IOException, ScribbleRuntimeException {
        this.use();
        this.se.getChannelEndpoint(peer).write(msg);
    }

    protected void connect(Role role, Callable<? extends BinaryChannelEndpoint> cons, String host, int port) throws ScribbleRuntimeException, UnknownHostException, IOException {
        this.use();
        this.se.connect(role, cons, host, port);
    }

    protected void disconnect(Role role) throws ScribbleRuntimeException, UnknownHostException, IOException {
        this.use();
        this.se.disconnect(role);
    }
}

