/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.net.ScribInterrupt;
import org.scribble.net.ScribMessage;
import org.scribble.net.session.SessionEndpoint;

public abstract class BinaryChannelEndpoint {
    protected SessionEndpoint<?, ?> se;
    private AbstractSelectableChannel c;
    private ByteBuffer bb;
    protected final List<ScribMessage> msgs = new LinkedList<ScribMessage>();
    private boolean isClosed = false;
    private int count = 0;
    private int ticket = 0;
    private final List<CompletableFuture<ScribMessage>> pending = new LinkedList<CompletableFuture<ScribMessage>>();

    protected BinaryChannelEndpoint(SessionEndpoint<?, ?> se, AbstractSelectableChannel c) throws IOException {
        this.bb = ByteBuffer.allocate(16921);
        this.init(se, c);
    }

    protected BinaryChannelEndpoint() {
        this.bb = ByteBuffer.allocate(16921);
    }

    public abstract void initClient(SessionEndpoint<?, ?> var1, String var2, int var3) throws IOException;

    protected void init(SessionEndpoint<?, ?> se, AbstractSelectableChannel c) throws IOException {
        this.se = se;
        this.c = c;
        this.c.configureBlocking(false);
    }

    public void wrapChannel(BinaryChannelEndpoint c) throws IOException {
        this.se = c.se;
        this.c = c.c;
        this.bb = c.bb;
    }

    public AbstractSelectableChannel getSelectableChannel() {
        return this.c;
    }

    public void write(ScribMessage m) throws IOException {
        this.writeBytes(this.se.smf.toBytes(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<ScribMessage> getFuture() {
        int ticket = this.getTicket();
        CompletableFuture<ScribMessage> fut = CompletableFuture.supplyAsync(() -> {
            try {
                ScribMessage m = this.read(ticket);
                if (m instanceof ScribInterrupt) {
                    throw new RuntimeScribbleException((Throwable)((ScribInterrupt)m).payload[0]);
                }
                ScribMessage scribMessage = m;
                return scribMessage;
            }
            catch (IOException e) {
                throw new RuntimeScribbleException(e);
            }
            finally {
                this.pending.remove(0);
            }
        });
        List<CompletableFuture<ScribMessage>> list = this.pending;
        synchronized (list) {
            this.pending.add(fut);
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync() throws IOException {
        try {
            List<CompletableFuture<ScribMessage>> list = this.pending;
            synchronized (list) {
                if (!this.pending.isEmpty()) {
                    this.pending.get(this.pending.size() - 1).get();
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private synchronized ScribMessage read(int ticket) throws IOException {
        try {
            while (this.count < ticket && !this.isClosed) {
                this.wait();
            }
            while (this.msgs.isEmpty() && !this.isClosed) {
                this.wait();
            }
            if (this.isClosed) {
                throw new IOException("Channel closed");
            }
            ++this.count;
            ScribMessage m = this.msgs.remove(0);
            this.notifyAll();
            return m;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected synchronized void enqueue(ScribMessage m) {
        this.msgs.add(m);
        this.notifyAll();
    }

    public abstract void writeBytes(byte[] var1) throws IOException;

    protected abstract void readBytesIntoBuffer() throws IOException;

    public synchronized void readAndEnqueueMessages() throws ClassNotFoundException, IOException {
        ScribMessage m;
        this.readBytesIntoBuffer();
        while ((m = this.se.smf.fromBytes(this.bb)) != null) {
            this.enqueue(m);
        }
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.notifyAll();
    }

    public synchronized int getTicket() {
        return this.ticket++;
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }
}

