/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.net.ScribInterrupt;
import org.scribble.net.ScribMessage;
import org.scribble.sesstype.name.Role;

@Deprecated
public class EndpointInputQueues {
    private final Map<Role, List<ScribMessage>> queues = new HashMap<Role, List<ScribMessage>>();
    private final Map<Role, Integer> counts = new HashMap<Role, Integer>();
    private final Map<Role, Integer> tickets = new HashMap<Role, Integer>();

    public synchronized int getTicket(Role peer) {
        int next = this.tickets.get(peer) + 1;
        this.tickets.put(peer, next);
        return next;
    }

    public synchronized void register(Role peer) {
        this.queues.put(peer, new LinkedList());
        this.counts.put(peer, 0);
        this.tickets.put(peer, 0);
    }

    public synchronized void enqueue(Role peer, ScribMessage o) {
        this.queues.get(peer).add(o);
        this.counts.put(peer, this.counts.get(peer) + 1);
        this.notifyAll();
    }

    public synchronized void interrupt(Role peer, Throwable t) {
        this.enqueue(peer, new ScribInterrupt(t));
    }

    public synchronized boolean isEmpty(Role peer) {
        return this.queues.get(peer).isEmpty();
    }

    public synchronized CompletableFuture<ScribMessage> getFuture(Role peer) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ScribMessage m = this.dequeue(peer, this.getTicket(peer));
                if (m instanceof ScribInterrupt) {
                    throw new RuntimeScribbleException((Throwable)((ScribInterrupt)m).payload[0]);
                }
                return m;
            }
            catch (IOException e) {
                throw new RuntimeScribbleException(e);
            }
        });
    }

    protected synchronized ScribMessage dequeue(Role peer, int ticket) throws IOException {
        try {
            while (this.counts.get(peer) < ticket) {
                this.wait();
            }
            List<ScribMessage> queue = this.queues.get(peer);
            while (queue.isEmpty()) {
                this.wait();
            }
            ScribMessage m = queue.remove(0);
            return m;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

