/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import org.scribble.net.session.BinaryChannelEndpoint;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.sesstype.name.Role;

public class ScribInputSelector
extends Thread {
    private SessionEndpoint<?, ?> se;
    private final Selector sel;
    private volatile boolean paused = false;
    private volatile boolean closed = false;

    public ScribInputSelector(SessionEndpoint<?, ?> se) throws IOException {
        this.se = se;
        this.sel = Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.closed) {
                this.sel.select();
                if (this.closed) {
                    return;
                }
                try {
                    ScribInputSelector scribInputSelector = this;
                    synchronized (scribInputSelector) {
                        while (this.paused) {
                            this.wait();
                        }
                        Set<SelectionKey> keys = this.sel.selectedKeys();
                        for (SelectionKey key : keys) {
                            if (key.isReadable()) {
                                Role peer = (Role)key.attachment();
                                this.se.chans.get(peer).readAndEnqueueMessages();
                                continue;
                            }
                            throw new RuntimeException("TODO: " + key);
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            try {
                this.sel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected Selector getSelector() {
        return this.sel;
    }

    protected SelectionKey register(AbstractSelectableChannel c) throws ClosedChannelException {
        return c.register(this.sel, 1);
    }

    protected void deregister(SelectionKey key) {
        key.cancel();
    }

    protected synchronized void clear() {
    }

    protected synchronized void pause() {
        this.paused = true;
        this.sel.wakeup();
    }

    protected synchronized void unpause() {
        this.paused = false;
        this.notify();
    }

    protected synchronized void close() {
        this.closed = true;
        this.paused = false;
        for (Role peer : this.se.getPeers()) {
            try {
                BinaryChannelEndpoint c = this.se.getChannelEndpoint(peer);
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.sel.wakeup();
    }
}

