/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.scribble.main.ScribbleException;
import org.scribble.main.ScribbleRuntimeException;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public abstract class Session {
    private static final Map<Integer, Session> sessions = new HashMap<Integer, Session>();
    public final int id;
    public final List<String> impath;
    public final String modpath;
    public final GProtocolName proto;
    private final Map<Role, SessionEndpoint<?, ?>> endpoints = new HashMap();

    public Session(int id, List<String> impath, String modpath, GProtocolName proto) {
        this.id = id;
        this.impath = impath;
        this.modpath = modpath;
        this.proto = proto;
        sessions.put(id, this);
    }

    public Session(List<String> importPath, String source, GProtocolName proto) {
        this(Session.getFreshId(), importPath, source, proto);
    }

    protected void project(SessionEndpoint<?, ?> se) throws ScribbleRuntimeException, IOException {
        if (!this.getRoles().contains(se.self)) {
            throw new ScribbleRuntimeException("Invalid role: " + se.self);
        }
        if (this.endpoints.containsKey(se.self)) {
            throw new ScribbleRuntimeException("Session endpoint already created for: " + se.self);
        }
        this.endpoints.put(se.self, se);
    }

    public boolean hasEndpoint(Role role) {
        return this.endpoints.containsKey(role);
    }

    public <S extends Session, R extends Role> SessionEndpoint<S, R> getEndpoint(R role) throws ScribbleException {
        if (!this.endpoints.containsKey(role)) {
            throw new ScribbleException("No endpoint for: " + role);
        }
        SessionEndpoint<?, ?> cast = this.endpoints.get(role);
        return cast;
    }

    public static Session getSession(int id) throws ScribbleException {
        if (!sessions.containsKey(id)) {
            throw new ScribbleException("No such session: " + id);
        }
        return sessions.get(id);
    }

    private static int getFreshId() {
        Random random = new Random();
        int id = random.nextInt(10000);
        while (sessions.keySet().contains(id)) {
            id = random.nextInt(10000);
        }
        return id;
    }

    protected void finalize() {
        sessions.remove(this.id);
    }

    public abstract List<Role> getRoles();
}

