/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.net.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.scribble.net.session.BinaryChannelEndpoint;
import org.scribble.net.session.SessionEndpoint;

public class SocketChannelEndpoint
extends BinaryChannelEndpoint {
    public SocketChannelEndpoint(SessionEndpoint<?, ?> se, SocketChannel s) throws IOException {
        super(se, s);
    }

    public SocketChannelEndpoint() {
    }

    @Override
    public void initClient(SessionEndpoint<?, ?> se, String host, int port) throws IOException {
        SocketChannel s = SocketChannel.open(new InetSocketAddress(host, port));
        super.init(se, s);
    }

    @Override
    public SocketChannel getSelectableChannel() {
        return (SocketChannel)super.getSelectableChannel();
    }

    @Override
    public void writeBytes(byte[] bs) throws IOException {
        this.getSelectableChannel().write(ByteBuffer.wrap(bs));
    }

    @Override
    public synchronized void readBytesIntoBuffer() throws IOException {
        ByteBuffer bb = this.getBuffer();
        this.getSelectableChannel().read(bb);
    }

    @Override
    public void close() {
        try {
            super.close();
            this.getSelectableChannel().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

