/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.sesstype.name;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.scribble.sesstype.kind.ModuleKind;
import org.scribble.sesstype.name.Name;
import org.scribble.sesstype.name.PackageName;
import org.scribble.sesstype.name.QualifiedName;

public class ModuleName
extends QualifiedName<ModuleKind> {
    private static final long serialVersionUID = 1L;
    protected static final ModuleName EMPTY_MODULENAME = new ModuleName(new String[0]);

    protected ModuleName(String ... elems) {
        super(ModuleKind.KIND, elems);
    }

    public ModuleName(PackageName packname, ModuleName modname) {
        super(ModuleKind.KIND, ModuleName.compileModuleName(packname, modname));
    }

    public ModuleName(String modname) {
        super(ModuleKind.KIND, Name.compileElements(PackageName.EMPTY_PACKAGENAME.getElements(), modname));
    }

    public Path toPath() {
        String[] elems = this.getElements();
        String file = elems[0];
        int i = 1;
        while (i < elems.length) {
            file = String.valueOf(file) + "/" + elems[i];
            ++i;
        }
        return Paths.get(String.valueOf(file) + "." + "scr", new String[0]);
    }

    public boolean isSimpleName() {
        return !this.isPrefixed();
    }

    public ModuleName getSimpleName() {
        return new ModuleName(this.getLastElement());
    }

    public PackageName getPrefix() {
        return new PackageName(this.getPrefixElements());
    }

    public PackageName getPackageName() {
        return this.getPrefix();
    }

    private static String[] compileModuleName(PackageName packname, ModuleName modname) {
        return Name.compileElements(packname.getElements(), modname.getLastElement());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleName)) {
            return false;
        }
        ModuleName n = (ModuleName)o;
        return n.canEqual(this) && super.equals(o);
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof ModuleName;
    }

    @Override
    public int hashCode() {
        int hash = 2797;
        hash = 31 * super.hashCode();
        return hash;
    }
}

