/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.sesstype.name.Role;

public class ConnectedMap {
    private Map<Role, Map<Role, ConnectedStatus>> map = new HashMap<Role, Map<Role, ConnectedStatus>>();

    private static ConnectedStatus convertStatus(boolean b) {
        return b ? ConnectedStatus.TRUE : ConnectedStatus.FALSE;
    }

    public ConnectedMap(Set<Role> roles, boolean implicit) {
        roles.forEach(k -> {
            HashMap tmp = new HashMap();
            this.map.put((Role)k, tmp);
            roles.forEach(k2 -> {
                if (!k.equals(k2)) {
                    tmp.put(k2, ConnectedMap.convertStatus(implicit));
                }
            });
        });
    }

    public ConnectedMap(ConnectedMap map) {
        for (Role dest : map.getDestinations()) {
            for (Role src : map.map.get(dest).keySet()) {
                this.setConnected(dest, src, map.isConnected(dest, src));
            }
        }
    }

    public ConnectedMap merge(ConnectedMap them) {
        Map<Role, Map<Role, ConnectedStatus>> ours = this.map;
        Map<Role, Map<Role, ConnectedStatus>> theirs = them.map;
        ConnectedMap res = new ConnectedMap(Collections.emptySet(), false);
        HashSet<Role> rs = new HashSet<Role>(ours.keySet());
        rs.addAll(theirs.keySet());
        for (Role r1 : rs) {
            for (Role r2 : rs) {
                if (this.containsRolePair(r1, r2)) {
                    ConnectedStatus c1 = ours.get(r1).get(r2);
                    if (them.containsRolePair(r1, r2)) {
                        ConnectedStatus c2 = theirs.get(r1).get(r2);
                        ConnectedStatus c = c1 == c2 ? c1 : ConnectedStatus.AMBIG;
                        res.setConnected(r1, r2, c);
                        continue;
                    }
                    res.setConnected(r1, r2, c1);
                    continue;
                }
                if (!them.containsRolePair(r1, r2)) continue;
                ConnectedStatus c2 = theirs.get(r1).get(r2);
                res.setConnected(r1, r2, c2);
            }
        }
        return res;
    }

    public void connect(Role dest, Role src) {
        this.setConnected(dest, src, true);
    }

    public void disconnect(Role dest, Role src) {
        this.setConnected(dest, src, false);
    }

    protected void setConnected(Role dest, Role src, ConnectedStatus status) {
        this.addRolePair(dest, src);
        ConnectedStatus b = status;
        this.map.get(dest).put(src, b);
        this.addRolePair(src, dest);
        this.map.get(src).put(dest, b);
    }

    public void setConnected(Role dest, Role src, boolean isConnected) {
        this.setConnected(dest, src, ConnectedMap.convertStatus(isConnected));
    }

    public Set<Role> getDestinations() {
        return this.map.keySet();
    }

    public boolean containsDestination(Role dest) {
        return this.map.containsKey(dest);
    }

    public Set<Role> getSources(Role dest) {
        return this.map.containsKey(dest) ? this.map.get(dest).keySet() : Collections.emptySet();
    }

    public boolean isConnected(Role dest, Role src) {
        Map<Role, ConnectedStatus> tmp = this.map.get(dest);
        if (tmp != null) {
            ConnectedStatus b = tmp.get(src);
            return b == ConnectedStatus.TRUE;
        }
        return false;
    }

    public boolean containsRolePair(Role dest, Role src) {
        return this.map.keySet().contains(dest) && this.map.get(dest).containsKey(src);
    }

    public void clear() {
        this.map.clear();
    }

    private void addRolePair(Role dest, Role src) {
        if (!this.map.containsKey(dest)) {
            HashMap<Role, ConnectedStatus> map = new HashMap<Role, ConnectedStatus>();
            this.map.put(dest, map);
            map.put(src, ConnectedStatus.FALSE);
        } else if (!this.map.get(dest).containsKey(src)) {
            this.map.get(dest).put(src, ConnectedStatus.FALSE);
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        int hash = 1033;
        hash = 31 * hash + super.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ConnectedMap)) {
            return false;
        }
        return this.map.equals(((ConnectedMap)o).map);
    }

    public static enum ConnectedStatus {
        TRUE,
        FALSE,
        AMBIG;

    }
}

