/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Role;

public class MessageIdMap {
    private Map<Role, Map<Role, Set<MessageId<?>>>> map = new HashMap();

    public MessageIdMap() {
    }

    public MessageIdMap(MessageIdMap map) {
        for (Role dest : map.getDestinations()) {
            for (Role src : map.map.get(dest).keySet()) {
                this.putMessages(dest, src, map.getMessages(dest, src));
            }
        }
    }

    public void putMessage(Role dest, Role src, MessageId<?> msg) {
        this.addRolePair(dest, src);
        this.map.get(dest).get(src).add(msg);
    }

    public void putMessages(Role dest, Role src, Set<MessageId<?>> msgs) {
        this.addRolePair(dest, src);
        this.map.get(dest).get(src).addAll(msgs);
    }

    public Set<Role> getDestinations() {
        return this.map.keySet();
    }

    public boolean containsDestination(Role dest) {
        return this.map.containsKey(dest);
    }

    public Set<Role> getSources(Role dest) {
        return this.map.containsKey(dest) ? this.map.get(dest).keySet() : Collections.emptySet();
    }

    public Set<MessageId<?>> getMessages(Role dest, Role src) {
        return this.map.get(dest).get(src);
    }

    public Set<MessageId<?>> getMessages(Role dest) {
        HashSet tmp = new HashSet();
        this.getSources(dest).forEach(src -> {
            boolean bl = tmp.addAll(this.getMessages(dest, (Role)src));
        });
        return tmp;
    }

    public boolean containsRolePair(Role dest, Role src) {
        return this.map.keySet().contains(dest) && this.map.get(dest).containsKey(src);
    }

    public void clear() {
        this.map.clear();
    }

    private void addRolePair(Role dest, Role src) {
        if (!this.map.containsKey(dest)) {
            HashMap map = new HashMap();
            this.map.put(dest, map);
            map.put(src, new HashSet());
        } else if (!this.map.get(dest).containsKey(src)) {
            this.map.get(dest).put(src, new HashSet());
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

