/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import org.scribble.ast.ProtocolDef;
import org.scribble.ast.ScribNode;
import org.scribble.del.ProtocolDefDel;
import org.scribble.main.ScribbleException;
import org.scribble.visit.EnvVisitor;
import org.scribble.visit.Job;
import org.scribble.visit.env.Env;

public abstract class InlinedProtocolVisitor<T extends Env<?>>
extends EnvVisitor<T> {
    public InlinedProtocolVisitor(Job job) {
        super(job);
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        this.enter(parent, child);
        ScribNode visited = this.visitInlinedProtocol(parent, child);
        return this.leave(parent, child, visited);
    }

    protected ScribNode visitInlinedProtocol(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof ProtocolDef) {
            return this.visitOverrideForProtocolDef(parent, (ProtocolDef)child);
        }
        return child.visitChildren(this);
    }

    private ScribNode visitOverrideForProtocolDef(ScribNode parent, ProtocolDef<?> pd) throws ScribbleException {
        ProtocolDef<?> inlined = ((ProtocolDefDel)pd.del()).getInlinedProtocolDef();
        if (inlined == null) {
            throw new ScribbleException("InlineProtocolVisitor error: " + pd);
        }
        ScribNode visited = inlined.visitChildren(this);
        ProtocolDefDel del = (ProtocolDefDel)pd.del();
        return pd.del(del.setInlinedProtocolDef((ProtocolDef<?>)visited));
    }

    @Override
    protected final void envEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.envEnter(parent, child);
        this.inlinedProtocolEnter(parent, child);
    }

    @Override
    protected final ScribNode envLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        ScribNode n = this.inlinedProtocolLeave(parent, child, visited);
        return super.envLeave(parent, child, n);
    }

    protected void inlinedProtocolEnter(ScribNode parent, ScribNode child) throws ScribbleException {
    }

    protected ScribNode inlinedProtocolLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        return visited;
    }
}

