/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.del.local.LProtocolDeclDel;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.AstVisitor;
import org.scribble.visit.DelegationProtocolRefChecker;
import org.scribble.visit.GlobalModelChecker;
import org.scribble.visit.InlinedProtocolUnfolder;
import org.scribble.visit.JobContext;
import org.scribble.visit.ModuleContextBuilder;
import org.scribble.visit.NameDisambiguator;
import org.scribble.visit.ProjectedChoiceDoPruner;
import org.scribble.visit.ProjectedChoiceSubjectFixer;
import org.scribble.visit.ProjectedRoleDeclFixer;
import org.scribble.visit.Projector;
import org.scribble.visit.ProtocolDeclContextBuilder;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.ReachabilityChecker;
import org.scribble.visit.RoleCollector;
import org.scribble.visit.WFChoiceChecker;

public class Job {
    public final boolean debug;
    public final boolean useOldWf;
    public final boolean noLiveness;
    public final boolean minEfsm;
    public final boolean fair;
    public final boolean noLocalChoiceSubjectCheck;
    private final JobContext jcontext;

    public Job(boolean debug, Map<ModuleName, Module> parsed, ModuleName main, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck) {
        this.debug = debug;
        this.useOldWf = useOldWF;
        this.noLiveness = noLiveness;
        this.minEfsm = minEfsm;
        this.fair = fair;
        this.noLocalChoiceSubjectCheck = noLocalChoiceSubjectCheck;
        this.jcontext = new JobContext(this, parsed, main);
    }

    public ScribbleException testWellFormednessCheck() {
        try {
            this.checkWellFormedness();
        }
        catch (ScribbleException x) {
            return x;
        }
        return null;
    }

    public void checkWellFormedness() throws ScribbleException {
        this.runContextBuildingPasses();
        this.runVisitorPassOnAllModules(WFChoiceChecker.class);
        this.runProjectionPasses();
        this.runVisitorPassOnAllModules(ReachabilityChecker.class);
        if (!this.useOldWf) {
            this.runVisitorPassOnAllModules(GlobalModelChecker.class);
        }
    }

    private void runContextBuildingPasses() throws ScribbleException {
        this.runVisitorPassOnAllModules(ModuleContextBuilder.class);
        this.runVisitorPassOnAllModules(NameDisambiguator.class);
        this.runVisitorPassOnAllModules(ProtocolDeclContextBuilder.class);
        this.runVisitorPassOnAllModules(DelegationProtocolRefChecker.class);
        this.runVisitorPassOnAllModules(RoleCollector.class);
        this.runVisitorPassOnAllModules(ProtocolDefInliner.class);
        this.runVisitorPassOnAllModules(InlinedProtocolUnfolder.class);
    }

    private void runProjectionPasses() throws ScribbleException {
        this.runVisitorPassOnAllModules(Projector.class);
        this.runProjectionContextBuildingPasses();
    }

    private void runProjectionContextBuildingPasses() throws ScribbleException {
        this.runVisitorPassOnProjectedModules(ModuleContextBuilder.class);
        this.runVisitorPassOnProjectedModules(ProtocolDeclContextBuilder.class);
        this.runVisitorPassOnProjectedModules(RoleCollector.class);
        this.runVisitorPassOnProjectedModules(ProjectedChoiceDoPruner.class);
        if (!this.noLocalChoiceSubjectCheck) {
            this.runVisitorPassOnProjectedModules(ProjectedChoiceSubjectFixer.class);
        }
        this.runVisitorPassOnProjectedModules(ProjectedRoleDeclFixer.class);
        this.runVisitorPassOnProjectedModules(ProtocolDefInliner.class);
        this.runVisitorPassOnProjectedModules(InlinedProtocolUnfolder.class);
    }

    public Map<LProtocolName, Module> getProjections(GProtocolName fullname, Role role) throws ScribbleException {
        Module root = this.jcontext.getProjection(fullname, role);
        Map dependencies = ((LProtocolDeclDel)root.getLocalProtocolDecls().get(0).del()).getProtocolDeclContext().getDependencyMap().getDependencies().get(role);
        return dependencies.keySet().stream().collect(Collectors.toMap(lpn -> lpn, lpn -> this.jcontext.getModule(lpn.getPrefix())));
    }

    public Map<String, String> generateSessionApi(GProtocolName fullname) throws ScribbleException {
        this.debugPrintPass("Running " + SessionApiGenerator.class + " for " + fullname);
        SessionApiGenerator sg = new SessionApiGenerator(this, fullname);
        Map<String, String> map = sg.generateApi();
        return map;
    }

    public Map<String, String> generateStateChannelApi(GProtocolName fullname, Role self, boolean subtypes) throws ScribbleException {
        this.debugPrintPass("Running " + StateChannelApiGenerator.class + " for " + fullname + "@" + self);
        StateChannelApiGenerator apigen = new StateChannelApiGenerator(this, fullname, self);
        IOInterfacesGenerator iogen = null;
        try {
            iogen = new IOInterfacesGenerator(apigen, subtypes);
        }
        catch (RuntimeScribbleException e) {
            System.err.println("[Warning] Skipping I/O Interface generation for: " + fullname + "\n  Cause: " + e.getMessage());
        }
        HashMap<String, String> api = new HashMap<String, String>();
        api.putAll(apigen.generateApi());
        if (iogen != null) {
            api.putAll(iogen.generateApi());
        }
        return api;
    }

    private void runVisitorPassOnAllModules(Class<? extends AstVisitor> c) throws ScribbleException {
        this.debugPrintPass("Running " + c + " on all modules:");
        this.runVisitorPass(this.jcontext.getFullModuleNames(), c);
    }

    private void runVisitorPassOnProjectedModules(Class<? extends AstVisitor> c) throws ScribbleException {
        this.debugPrintPass("Running " + c + " on projected modules:");
        this.runVisitorPass(this.jcontext.getProjectedFullModuleNames(), c);
    }

    private void runVisitorPass(Set<ModuleName> modnames, Class<? extends AstVisitor> c) throws ScribbleException {
        try {
            Constructor<? extends AstVisitor> cons = c.getConstructor(Job.class);
            for (ModuleName modname : modnames) {
                AstVisitor nv = cons.newInstance(this);
                Module visited = (Module)this.jcontext.getModule(modname).accept(nv);
                this.jcontext.replaceModule(visited);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public JobContext getContext() {
        return this.jcontext;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void debugPrintln(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void debugPrintPass(String s) {
        this.debugPrintln("\n[DEBUG] " + s);
    }
}

