/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.AutParser;
import org.scribble.model.local.EndpointGraph;
import org.scribble.model.wf.WFState;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ScribUtil;
import org.scribble.visit.EndpointGraphBuilder;
import org.scribble.visit.Job;
import org.scribble.visit.Projector;

public class JobContext {
    private final Job job;
    public final ModuleName main;
    private final Map<ModuleName, Module> parsed;
    private final Map<LProtocolName, Module> projected = new HashMap<LProtocolName, Module>();
    private final Map<LProtocolName, EndpointGraph> graphs = new HashMap<LProtocolName, EndpointGraph>();
    private final Map<GProtocolName, WFState> gmodels = new HashMap<GProtocolName, WFState>();
    private final Map<LProtocolName, EndpointGraph> unfair = new HashMap<LProtocolName, EndpointGraph>();
    private final Map<LProtocolName, EndpointGraph> minimised = new HashMap<LProtocolName, EndpointGraph>();

    protected JobContext(Job job, Map<ModuleName, Module> parsed, ModuleName main) {
        this.job = job;
        this.parsed = new HashMap<ModuleName, Module>(parsed);
        this.main = main;
    }

    public Set<ModuleName> getFullModuleNames() {
        HashSet<ModuleName> modnames = new HashSet<ModuleName>();
        modnames.addAll(this.getParsedFullModuleNames());
        modnames.addAll(this.getProjectedFullModuleNames());
        return modnames;
    }

    public Set<ModuleName> getParsedFullModuleNames() {
        HashSet<ModuleName> modnames = new HashSet<ModuleName>();
        modnames.addAll(this.parsed.keySet());
        return modnames;
    }

    public Set<ModuleName> getProjectedFullModuleNames() {
        return this.projected.keySet().stream().map(lpn -> lpn.getPrefix()).collect(Collectors.toSet());
    }

    private boolean isParsedModule(ModuleName fullname) {
        return this.parsed.containsKey(fullname);
    }

    private boolean isProjectedModule(ModuleName fullname) {
        return this.getProjectedFullModuleNames().contains(fullname);
    }

    public Module getModule(ModuleName fullname) {
        if (this.isParsedModule(fullname)) {
            return this.parsed.get(fullname);
        }
        if (this.isProjectedModule(fullname)) {
            return this.projected.get(this.projected.keySet().stream().filter(lpn -> lpn.getPrefix().equals(fullname)).collect(Collectors.toList()).get(0));
        }
        throw new RuntimeException("Unknown module: " + fullname);
    }

    protected void replaceModule(Module module) {
        ModuleName fullname = module.getFullModuleName();
        if (this.isParsedModule(fullname)) {
            this.parsed.put(fullname, module);
        } else if (this.isProjectedModule(fullname)) {
            this.addProjection(module);
        } else {
            throw new RuntimeException("Unknown module: " + fullname);
        }
    }

    public void addProjections(Map<GProtocolName, Map<Role, Module>> projections) {
        for (GProtocolName gpn : projections.keySet()) {
            Map<Role, Module> mods = projections.get(gpn);
            for (Role role : mods.keySet()) {
                this.addProjection(mods.get(role));
            }
        }
    }

    private void addProjection(Module mod) {
        LProtocolName lpn = (LProtocolName)mod.getProtocolDecls().get(0).getFullMemberName(mod);
        this.projected.put(lpn, mod);
    }

    public Module getProjection(GProtocolName fullname, Role role) throws ScribbleException {
        Module proj = this.projected.get(Projector.projectFullProtocolName(fullname, role));
        if (proj == null) {
            throw new ScribbleException("Projection not found: " + fullname + ", " + role);
        }
        return proj;
    }

    public void addGlobalModel(GProtocolName fullname, WFState model) {
        this.gmodels.put(fullname, model);
    }

    public WFState getGlobalModel(GProtocolName fullname) {
        return this.gmodels.get(fullname);
    }

    protected void addEndpointGraph(LProtocolName fullname, EndpointGraph graph) {
        this.graphs.put(fullname, graph);
    }

    public EndpointGraph getEndpointGraph(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EndpointGraph graph = this.graphs.get(fulllpn);
        if (graph == null) {
            Module proj = this.getProjection(fullname, role);
            EndpointGraphBuilder builder = new EndpointGraphBuilder(this.job);
            proj.accept(builder);
            graph = builder.builder.finalise();
            this.addEndpointGraph(fulllpn, graph);
        }
        return graph;
    }

    protected void addMinimisedEndpointGraph(LProtocolName fullname, EndpointGraph graph) {
        this.minimised.put(fullname, graph);
    }

    public EndpointGraph getMinimisedEndpointGraph(GProtocolName fullname, Role role) throws ScribbleException {
        return this.getMinimisedEndpointGraphAux(fullname, role);
    }

    protected EndpointGraph getMinimisedEndpointGraphAux(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EndpointGraph minimised = this.minimised.get(fulllpn);
        if (minimised == null) {
            String aut = JobContext.runAut(this.getEndpointGraph((GProtocolName)fullname, (Role)role).init.toAut(), fulllpn + ".aut");
            minimised = new AutParser().parse(aut);
            this.addMinimisedEndpointGraph(fulllpn, minimised);
        }
        return minimised;
    }

    protected void addUnfairEndpointGraph(LProtocolName fullname, EndpointGraph graph) {
        this.unfair.put(fullname, graph);
    }

    public EndpointGraph getUnfairEndpointGraph(GProtocolName fullname, Role role) throws ScribbleException {
        return this.getUnfairEndpointGraphAux(fullname, role);
    }

    protected EndpointGraph getUnfairEndpointGraphAux(GProtocolName fullname, Role role) throws ScribbleException {
        LProtocolName fulllpn = Projector.projectFullProtocolName(fullname, role);
        EndpointGraph unfair = this.unfair.get(fulllpn);
        if (unfair == null) {
            unfair = this.getEndpointGraph((GProtocolName)fullname, (Role)role).init.unfairTransform().toGraph();
            this.addUnfairEndpointGraph(fulllpn, unfair);
        }
        return unfair;
    }

    public Module getMainModule() {
        return this.getModule(this.main);
    }

    private static String runAut(String fsm, String aut) throws ScribbleException {
        String tmpName = String.valueOf(aut) + ".tmp";
        File tmp = new File(tmpName);
        if (tmp.exists()) {
            throw new RuntimeException("Cannot overwrite: " + tmpName);
        }
        try {
            ScribUtil.writeToFile(tmpName, fsm);
            String[] res = ScribUtil.runProcess("ltsconvert", "-ebisim", "-iaut", "-oaut", tmpName);
            if (!res[1].isEmpty()) {
                throw new RuntimeException(res[1]);
            }
            String string = res[0];
            return string;
        }
        finally {
            tmp.delete();
        }
    }
}

