/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.scribble.ast.Do;
import org.scribble.ast.NonRoleArgList;
import org.scribble.ast.NonRoleArgNode;
import org.scribble.ast.NonRoleParamDecl;
import org.scribble.ast.NonRoleParamDeclList;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.RoleArgList;
import org.scribble.ast.RoleDeclList;
import org.scribble.ast.ScopedNode;
import org.scribble.ast.ScribNode;
import org.scribble.ast.context.ModuleContext;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.Arg;
import org.scribble.sesstype.SubprotocolSig;
import org.scribble.sesstype.kind.NonRoleArgKind;
import org.scribble.sesstype.kind.NonRoleParamKind;
import org.scribble.sesstype.name.Name;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.sesstype.name.Scope;
import org.scribble.visit.EnvVisitor;
import org.scribble.visit.Job;
import org.scribble.visit.JobContext;
import org.scribble.visit.Substitutor;
import org.scribble.visit.env.Env;

public abstract class SubprotocolVisitor<T extends Env<?>>
extends EnvVisitor<T> {
    protected List<SubprotocolSig> stack = new LinkedList<SubprotocolSig>();
    protected Stack<Map<Role, RoleNode>> rolemaps = new Stack();
    protected Stack<Map<Arg<? extends NonRoleArgKind>, NonRoleArgNode>> argmaps = new Stack();
    private Scope scope = null;

    public SubprotocolVisitor(Job job) {
        super(job);
    }

    protected void enterRootProtocolDecl(ProtocolDecl<?> pd) {
        Map<Role, RoleNode> rolemap = SubprotocolVisitor.makeRootRoleSubsMap(pd.header.roledecls);
        Map<Arg<NonRoleArgKind>, NonRoleArgNode> argmap = SubprotocolVisitor.makeRootNonRoleSubsMap(pd.header.paramdecls);
        this.rolemaps.push(rolemap);
        this.argmaps.push(argmap);
        ModuleContext mcontext = this.getModuleContext();
        ProtocolName fullname = mcontext.getVisibleProtocolDeclFullName(pd.header.getDeclName());
        List<Role> roleargs = pd.header.roledecls.getRoles();
        List<Arg<? extends NonRoleArgKind>> nonroleargs = pd.header.paramdecls.getDecls().stream().map(param -> SubprotocolVisitor.paramDeclToArg(param)).collect(Collectors.toList());
        this.pushSubprotocolSig(fullname, roleargs, nonroleargs);
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        this.enter(parent, child);
        ScribNode visited = this.visitForSubprotocols(parent, child);
        return this.leave(parent, child, visited);
    }

    protected ScribNode visitForSubprotocols(ScribNode parent, ScribNode child) throws ScribbleException {
        if (child instanceof Do) {
            return this.visitOverrideForDo(parent, (Do)child);
        }
        return child.visitChildren(this);
    }

    protected Do<?> visitOverrideForDo(ScribNode parent, Do<?> doo) throws ScribbleException {
        if (!this.isCycle()) {
            JobContext jc = this.getJobContext();
            ModuleContext mc = this.getModuleContext();
            ProtocolDecl<?> pd = doo.getTargetProtocolDecl(jc, mc);
            ScribNode seq = this.applySubstitutions(pd.def.block.seq.clone());
            seq.accept(this);
        }
        return doo;
    }

    protected boolean overrideSubstitution() {
        return false;
    }

    protected ScribNode applySubstitutions(ScribNode n) {
        if (this.overrideSubstitution()) {
            return n;
        }
        try {
            return n.accept(new Substitutor(this.getJob(), this.rolemaps.peek(), this.argmaps.peek()));
        }
        catch (ScribbleException e) {
            throw new RuntimeException("Shouldn't get in here: " + n);
        }
    }

    @Override
    protected final void envEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        ScopedNode sn;
        super.envEnter(parent, child);
        if (child instanceof ProtocolDecl) {
            this.setScope(Scope.ROOT_SCOPE);
            this.enterRootProtocolDecl((ProtocolDecl)child);
        }
        if (child instanceof ScopedNode && !(sn = (ScopedNode)((Object)child)).isEmptyScope()) {
            this.setScope(new Scope(this.getScope(), sn.getScopeElement()));
        }
        if (child instanceof Do) {
            this.enterSubprotocol((Do)child);
        }
        this.subprotocolEnter(parent, child);
    }

    @Override
    protected final ScribNode envLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        ScribNode n = this.subprotocolLeave(parent, child, visited);
        if (child instanceof ProtocolDecl) {
            this.envLeaveProtocolDeclOverride(parent, child, visited);
        }
        if (child instanceof Do) {
            this.leaveSubprotocol();
        }
        if (child instanceof ScopedNode && !((ScopedNode)((Object)child)).isEmptyScope()) {
            this.setScope(this.getScope().getPrefix());
        }
        return super.envLeave(parent, child, n);
    }

    protected void envLeaveProtocolDeclOverride(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        this.leaveSubprotocol();
    }

    protected void subprotocolEnter(ScribNode parent, ScribNode child) throws ScribbleException {
    }

    protected ScribNode subprotocolLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        return visited;
    }

    private void enterSubprotocol(Do<?> doo) {
        ProtocolName fullname = this.getModuleContext().checkProtocolDeclDependencyFullName(doo.proto.toName());
        this.pushSubprotocolSig(fullname, doo.roles.getRoles(), doo.args.getArguments());
        this.pushNameMaps(fullname, doo);
    }

    private void leaveSubprotocol() {
        this.stack.remove(this.stack.size() - 1);
        this.rolemaps.pop();
        this.argmaps.pop();
    }

    private void pushSubprotocolSig(ProtocolName<?> fullname, List<Role> roleargs, List<Arg<? extends NonRoleArgKind>> nonroleargs) {
        SubprotocolSig subsig = new SubprotocolSig(fullname, roleargs, nonroleargs);
        this.stack.add(subsig);
    }

    private void pushNameMaps(ProtocolName<?> fullname, Do<?> doo) {
        ProtocolDecl pd = this.getJobContext().getModule(fullname.getPrefix()).getProtocolDecl(fullname.getSimpleName());
        this.rolemaps.push(SubprotocolVisitor.makeRoleSubsMap((Map)this.rolemaps.get(0), doo.roles, pd.header.roledecls));
        this.argmaps.push(SubprotocolVisitor.makeNonRoleSubsMap((Map)this.argmaps.get(0), doo.args, pd.header.paramdecls));
    }

    public boolean isRootedCycle() {
        return this.stack.size() > 1 && this.stack.get(0).equals(this.stack.get(this.stack.size() - 1));
    }

    public boolean isCycle() {
        return this.getCycleEntryIndex() != -1;
    }

    public int getCycleEntryIndex() {
        int size = this.stack.size();
        if (size > 1) {
            SubprotocolSig last = this.stack.get(size - 1);
            int i = size - 2;
            while (i >= 0) {
                if (this.stack.get(i).equals(last)) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public List<SubprotocolSig> getStack() {
        return this.stack;
    }

    public boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    public SubprotocolSig peekStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    public Scope getScope() {
        return this.scope;
    }

    protected void setScope(Scope scope) {
        this.scope = scope;
    }

    protected static Map<Role, RoleNode> makeRootRoleSubsMap(RoleDeclList rdl) {
        return rdl.getDecls().stream().collect(Collectors.toMap(r -> r.getDeclName(), r -> (RoleNode)r.name));
    }

    protected static Map<Arg<? extends NonRoleArgKind>, NonRoleArgNode> makeRootNonRoleSubsMap(NonRoleParamDeclList pdl) {
        return pdl.getDecls().stream().collect(Collectors.toMap(p -> (Arg)((Object)p.getDeclName()), p -> (NonRoleArgNode)((Object)p.name)));
    }

    protected static Map<Role, RoleNode> makeRoleSubsMap(Map<Role, RoleNode> root, RoleArgList ral, RoleDeclList rdl) {
        Iterator<Role> roleargs = ral.getRoles().iterator();
        return rdl.getRoles().stream().collect(Collectors.toMap(r -> r, r -> (RoleNode)root.get(roleargs.next())));
    }

    protected static Map<Arg<? extends NonRoleArgKind>, NonRoleArgNode> makeNonRoleSubsMap(Map<Arg<? extends NonRoleArgKind>, NonRoleArgNode> root, NonRoleArgList nral, NonRoleParamDeclList nrpdl) {
        HashMap<Arg<? extends NonRoleArgKind>, NonRoleArgNode> newmap = new HashMap<Arg<? extends NonRoleArgKind>, NonRoleArgNode>();
        Iterator<Arg<? extends NonRoleArgKind>> nonroleargs = nral.getArguments().iterator();
        Iterator<NonRoleArgNode> nonroleargnodes = nral.getArgumentNodes().iterator();
        for (Name<NonRoleParamKind> param : nrpdl.getParameters()) {
            NonRoleArgNode argnode;
            Arg<? extends NonRoleArgKind> arg = nonroleargs.next();
            if (root.containsKey(arg)) {
                argnode = root.get(arg);
                nonroleargnodes.next();
            } else {
                argnode = nonroleargnodes.next();
            }
            newmap.put((Arg)((Object)param), argnode);
        }
        return newmap;
    }

    private static Arg<? extends NonRoleArgKind> paramDeclToArg(NonRoleParamDecl<NonRoleParamKind> pd) {
        Name n = pd.getDeclName();
        if (!(n instanceof Arg)) {
            throw new RuntimeException("Shouldn't get in here: " + n);
        }
        Arg tmp = (Arg)((Object)n);
        return tmp;
    }
}

