/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit;

import java.util.HashSet;
import java.util.Set;
import org.scribble.ast.Choice;
import org.scribble.ast.InteractionSeq;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.Job;
import org.scribble.visit.UnfoldingVisitor;
import org.scribble.visit.env.WFChoiceEnv;

public class WFChoiceChecker
extends UnfoldingVisitor<WFChoiceEnv> {
    private Set<Choice<?>> visited = new HashSet();

    public WFChoiceChecker(Job job) {
        super(job);
    }

    @Override
    protected WFChoiceEnv makeRootProtocolDeclEnv(ProtocolDecl<? extends ProtocolKind> pd) {
        return new WFChoiceEnv(new HashSet<Role>(pd.header.roledecls.getRoles()), !pd.isGlobal() || !((GProtocolDecl)pd).modifiers.contains((Object)GProtocolDecl.Modifiers.EXPLICIT));
    }

    @Override
    public ScribNode visit(ScribNode parent, ScribNode child) throws ScribbleException {
        GProtocolDecl gpd;
        if (child instanceof GProtocolDecl && (gpd = (GProtocolDecl)child).isAuxModifier()) {
            return child;
        }
        if (this.getJob().useOldWf && child instanceof Choice) {
            return this.visitOverrideForChoice((InteractionSeq)parent, (Choice)child);
        }
        return super.visit(parent, child);
    }

    private ScribNode visitOverrideForChoice(InteractionSeq<?> parent, Choice<?> child) throws ScribbleException {
        if (child instanceof Choice) {
            Choice<?> cho = child;
            if (!this.visited.contains(cho)) {
                this.visited.add(cho);
                ScribNode n = super.visit(parent, child);
                this.visited.remove(cho);
                return n;
            }
            return cho;
        }
        return super.visit(parent, child);
    }

    @Override
    protected void unfoldingEnter(ScribNode parent, ScribNode child) throws ScribbleException {
        super.unfoldingEnter(parent, child);
        child.del().enterInlinedWFChoiceCheck(parent, child, this);
    }

    @Override
    protected ScribNode unfoldingLeave(ScribNode parent, ScribNode child, ScribNode visited) throws ScribbleException {
        visited = visited.del().leaveInlinedWFChoiceCheck(parent, child, this, visited);
        return super.unfoldingLeave(parent, child, visited);
    }
}

