/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.env;

import java.util.Arrays;
import java.util.List;
import org.scribble.visit.env.Env;

public class UnfoldingEnv
extends Env<UnfoldingEnv> {
    private boolean shouldUnfold;

    public UnfoldingEnv() {
        this.shouldUnfold = false;
    }

    protected UnfoldingEnv(boolean shouldUnfold) {
        this.shouldUnfold = shouldUnfold;
    }

    @Override
    protected UnfoldingEnv copy() {
        return new UnfoldingEnv(this.shouldUnfold);
    }

    @Override
    public UnfoldingEnv enterContext() {
        return this.copy();
    }

    public UnfoldingEnv mergeContext(UnfoldingEnv env) {
        return this.mergeContexts((List)Arrays.asList(env));
    }

    public UnfoldingEnv mergeContexts(List<UnfoldingEnv> envs) {
        boolean merge;
        UnfoldingEnv copy = this.copy();
        copy.shouldUnfold = merge = envs.stream().filter(e -> e.shouldUnfold).count() > 0L;
        return copy;
    }

    public boolean shouldUnfold() {
        return this.shouldUnfold;
    }

    public UnfoldingEnv pushChoiceParent() {
        UnfoldingEnv copy = this.copy();
        copy.shouldUnfold = true;
        return copy;
    }

    public UnfoldingEnv disableUnfold() {
        UnfoldingEnv copy = this.copy();
        copy.shouldUnfold = false;
        return copy;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.shouldUnfold;
    }
}

