/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.visit.env;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scribble.sesstype.Message;
import org.scribble.sesstype.MessageSig;
import org.scribble.sesstype.Payload;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Op;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ConnectedMap;
import org.scribble.util.MessageIdMap;
import org.scribble.visit.env.Env;

public class WFChoiceEnv
extends Env<WFChoiceEnv> {
    private static final Role DUMMY_ROLE = new Role("__ROLE");
    private static final Op ROOT_OPERATOR = new Op("__ROOT");
    private static final Op SUBJECT_OPERATOR = new Op("__SUBJECT");
    private static final MessageSig ROOT_MESSAGESIGNATURE = new MessageSig(ROOT_OPERATOR, Payload.EMPTY_PAYLOAD);
    private static final MessageSig SUBJECT_MESSAGESIGNATURE = new MessageSig(SUBJECT_OPERATOR, Payload.EMPTY_PAYLOAD);
    private MessageIdMap initial;
    private ConnectedMap connected;

    public WFChoiceEnv(Set<Role> roles, boolean implicit) {
        this(new MessageIdMap(), new ConnectedMap(roles, implicit));
    }

    protected WFChoiceEnv(MessageIdMap initial, ConnectedMap connected) {
        this.initial = new MessageIdMap(initial);
        this.connected = new ConnectedMap(connected);
    }

    @Override
    protected WFChoiceEnv copy() {
        return new WFChoiceEnv(this.initial, this.connected);
    }

    public WFChoiceEnv clear() {
        WFChoiceEnv copy = this.copy();
        copy.initial.clear();
        return copy;
    }

    @Override
    public WFChoiceEnv enterContext() {
        return new WFChoiceEnv(this.initial, this.connected);
    }

    public WFChoiceEnv mergeContext(WFChoiceEnv child) {
        return this.mergeContexts((List)Arrays.asList(child));
    }

    public WFChoiceEnv mergeContexts(List<WFChoiceEnv> children) {
        WFChoiceEnv copy = this.copy();
        for (WFChoiceEnv child : children) {
            WFChoiceEnv.merge(this, copy.initial, child.initial);
        }
        ConnectedMap cm = children.get(0).getConnected();
        for (WFChoiceEnv e : children.subList(1, children.size())) {
            cm = cm.merge(e.getConnected());
        }
        copy.connected = cm;
        return copy;
    }

    private static void merge(WFChoiceEnv parent, MessageIdMap foo, MessageIdMap child) {
        for (Role dest : child.getDestinations()) {
            for (Role src : child.getSources(dest)) {
                if (parent.isEnabled(dest)) continue;
                foo.putMessages(dest, src, child.getMessages(dest, src));
            }
        }
    }

    public WFChoiceEnv enableRoleForRootProtocolDecl(Role role) {
        return this.addMessage(DUMMY_ROLE, role, ROOT_MESSAGESIGNATURE);
    }

    public WFChoiceEnv enableChoiceSubject(Role role) {
        return this.addMessage(DUMMY_ROLE, role, SUBJECT_MESSAGESIGNATURE);
    }

    public WFChoiceEnv connect(Role src, Role dest) {
        WFChoiceEnv copy = this.copy();
        copy.connected.connect(src, dest);
        return copy;
    }

    public WFChoiceEnv disconnect(Role src, Role dest) {
        WFChoiceEnv copy = this.copy();
        copy.connected.disconnect(src, dest);
        return copy;
    }

    public WFChoiceEnv addMessage(Role src, Role dest, Message msg) {
        WFChoiceEnv copy = this.copy();
        WFChoiceEnv.addMessages(copy.initial, src, dest, Arrays.asList(msg.getId()));
        return copy;
    }

    private static void addMessages(MessageIdMap map, Role src, Role dest, List<MessageId<?>> msgs) {
        if (!map.containsDestination(dest)) {
            map.putMessages(dest, src, new HashSet(msgs));
        }
    }

    public boolean isEnabled(Role role) {
        return this.initial.containsDestination(role);
    }

    public MessageIdMap getEnabled() {
        MessageIdMap tmp = new MessageIdMap(this.initial);
        return tmp;
    }

    public ConnectedMap getConnected() {
        ConnectedMap tmp = new ConnectedMap(this.connected);
        return tmp;
    }

    public boolean isConnected(Role r1, Role r2) {
        return this.connected.isConnected(r1, r2);
    }

    public String toString() {
        return "initial=" + this.initial.toString();
    }
}

