/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser;

import org.scribble.ast.Module;
import org.scribble.main.DefaultModuleLoader;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.Resource;
import org.scribble.main.resource.ResourceLocator;
import org.scribble.parser.AntlrParser;
import org.scribble.parser.ScribParser;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.util.Pair;
import org.scribble.util.ScribParserException;

public class ScribModuleLoader
extends DefaultModuleLoader {
    private ResourceLocator locator;
    private AntlrParser antlr;
    private ScribParser parser;

    public ScribModuleLoader(ResourceLocator locator, AntlrParser antlr, ScribParser parser) {
        this.locator = locator;
        this.antlr = antlr;
        this.parser = parser;
    }

    public Pair<Resource, Module> loadModule(ModuleName modname) throws ScribParserException, ScribbleException {
        Pair cached = super.loadModule(modname);
        if (cached != null) {
            return cached;
        }
        Resource res = this.locator.getResource(modname.toPath());
        Module parsed = (Module)this.parser.parse(this.antlr.parseAntlrTree(res));
        ScribModuleLoader.checkModuleName(modname, res, parsed);
        this.registerModule(res, parsed);
        return new Pair((Object)res, (Object)parsed);
    }

    private static void checkModuleName(ModuleName mn, Resource res, Module mod) {
        if (!mn.equals((Object)mod.getFullModuleName())) {
            throw new RuntimeException("Invalid module name " + mod.getFullModuleName() + " at path: " + res.getPath());
        }
    }
}

