/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser.ast;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.PayloadElem;
import org.scribble.ast.PayloadElemList;
import org.scribble.ast.name.PayloadElemNameNode;
import org.scribble.ast.name.qualified.DataTypeNode;
import org.scribble.ast.name.qualified.GProtocolNameNode;
import org.scribble.ast.name.simple.AmbigNameNode;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.parser.AntlrConstants;
import org.scribble.parser.ScribParser;
import org.scribble.parser.ast.name.AntlrAmbigName;
import org.scribble.parser.ast.name.AntlrQualifiedName;
import org.scribble.parser.ast.name.AntlrSimpleName;
import org.scribble.parser.util.ScribParserUtil;

public class AntlrPayloadElemList {
    public static PayloadElemList parsePayloadElemList(ScribParser parser, CommonTree ct) {
        List pes = AntlrPayloadElemList.getPayloadElements(ct).stream().map(pe -> AntlrPayloadElemList.parsePayloadElem(pe)).collect(Collectors.toList());
        return AstFactoryImpl.FACTORY.PayloadElemList(pes);
    }

    private static PayloadElem<?> parsePayloadElem(CommonTree ct) {
        AntlrConstants.AntlrNodeType type = ScribParserUtil.getAntlrNodeType(ct);
        if (type == AntlrConstants.AntlrNodeType.DELEGATION) {
            RoleNode rn = AntlrSimpleName.toRoleNode((CommonTree)ct.getChild(0));
            GProtocolNameNode gpnn = AntlrQualifiedName.toGProtocolNameNode((CommonTree)ct.getChild(1));
            return AstFactoryImpl.FACTORY.GDelegationElem(gpnn, rn);
        }
        if (type == AntlrConstants.AntlrNodeType.QUALIFIEDNAME) {
            if (ct.getChildCount() > 1) {
                DataTypeNode dt = AntlrQualifiedName.toDataTypeNameNode(ct);
                return AstFactoryImpl.FACTORY.UnaryPayloadElem((PayloadElemNameNode)dt);
            }
            AmbigNameNode an = AntlrAmbigName.toAmbigNameNode(ct);
            return AstFactoryImpl.FACTORY.UnaryPayloadElem((PayloadElemNameNode)an);
        }
        throw new RuntimeException("Shouldn't get in here: " + ct);
    }

    public static final List<CommonTree> getPayloadElements(CommonTree ct) {
        return ct.getChildCount() == 0 ? Collections.emptyList() : ScribParserUtil.toCommonTreeList(ct.getChildren());
    }
}

