/*
 Copyright (C) 2011  The Autonomous Systems Lab, ETH Zurich,
 Stefan Leutenegger, Simon Lynen and Margarita Chli.

 Copyright (C) 2013  The Autonomous Systems Lab, ETH Zurich,
 Stefan Leutenegger and Simon Lynen.

 All rights reserved.

 This is the Author's implementation of BRISK: Binary Robust Invariant
 Scalable Keypoints [1]. Various (partly unpublished) extensions are provided,
 some of which are described in [2].

 [1] Stefan Leutenegger, Margarita Chli and Roland Siegwart. BRISK: Binary
     Robust Invariant Scalable Keypoints. In Proceedings of the IEEE
     International Conference on Computer Vision (ICCV), 2011.

 [2] Stefan Leutenegger. Unmanned Solar Airplanes: Design and Algorithms for
     Efficient and Robust Autonomous Operation. Doctoral dissertation, 2014.

 This file is part of BRISK.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
 * Neither the name of the Autonomous Systems Lab, ETH Zurich nor the
   names of its contributors may be used to endorse or promote products
   derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <assert.h>
#include <brisk/internal/pattern-provider.h>

namespace brisk {
void GetDefaultPatternAsStream(std::stringstream* pattern_stream) {
  assert(pattern_stream);

  pattern_stream->clear();
  *pattern_stream << "66" << std::endl;
  *pattern_stream << "0 0 6.000000e-01 " << std::endl;
  *pattern_stream << "1.190000e+00 0 6.000000e-01 " << std::endl;
  *pattern_stream << "5.950000e-01 1.030570e+00 6.000000e-01 " << std::endl;
  *pattern_stream << "-5.950000e-01 1.030570e+00 6.000000e-01 " << std::endl;
  *pattern_stream << "-1.190000e+00 1.457330e-16 6.000000e-01 " << std::endl;
  *pattern_stream << "-5.950000e-01 -1.030570e+00 6.000000e-01 " << std::endl;
  *pattern_stream << "5.950000e-01 -1.030570e+00 6.000000e-01 " << std::endl;
  *pattern_stream << "2.465000e+00 0 7.617269e-01 " << std::endl;
  *pattern_stream << "1.994227e+00 1.448891e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "7.617269e-01 2.344354e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "-7.617269e-01 2.344354e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "-1.994227e+00 1.448891e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "-2.465000e+00 3.018754e-16 7.617269e-01 " << std::endl;
  *pattern_stream << "-1.994227e+00 -1.448891e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "-7.617269e-01 -2.344354e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "7.617269e-01 -2.344354e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "1.994227e+00 -1.448891e+00 7.617269e-01 " << std::endl;
  *pattern_stream << "4.165000e+00 0 9.267997e-01 " << std::endl;
  *pattern_stream << "3.752535e+00 1.807126e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "2.596835e+00 3.256328e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "9.267997e-01 4.060575e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-9.267997e-01 4.060575e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-2.596835e+00 3.256328e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-3.752535e+00 1.807126e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-4.165000e+00 5.100654e-16 9.267997e-01 " << std::endl;
  *pattern_stream << "-3.752535e+00 -1.807126e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-2.596835e+00 -3.256328e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "-9.267997e-01 -4.060575e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "9.267997e-01 -4.060575e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "2.596835e+00 -3.256328e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "3.752535e+00 -1.807126e+00 9.267997e-01 " << std::endl;
  *pattern_stream << "6.290000e+00 0 1.307765e+00 " << std::endl;
  *pattern_stream << "5.746201e+00 2.558373e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "4.208832e+00 4.674381e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "1.943717e+00 5.982145e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-6.574840e-01 6.255543e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-3.145000e+00 5.447300e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-5.088717e+00 3.697169e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-6.152548e+00 1.307765e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-6.152548e+00 -1.307765e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-5.088717e+00 -3.697169e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-3.145000e+00 -5.447300e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "-6.574840e-01 -6.255543e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "1.943717e+00 -5.982145e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "4.208832e+00 -4.674381e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "5.746201e+00 -2.558373e+00 1.307765e+00 " << std::endl;
  *pattern_stream << "9.180000e+00 0 1.436068e+00 " << std::endl;
  *pattern_stream << "8.730699e+00 2.836776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "7.426776e+00 5.395869e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "5.395869e+00 7.426776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "2.836776e+00 8.730699e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "5.621129e-16 9.180000e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-2.836776e+00 8.730699e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-5.395869e+00 7.426776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-7.426776e+00 5.395869e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-8.730699e+00 2.836776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-9.180000e+00 1.124226e-15 1.436068e+00 " << std::endl;
  *pattern_stream << "-8.730699e+00 -2.836776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-7.426776e+00 -5.395869e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-5.395869e+00 -7.426776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-2.836776e+00 -8.730699e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "-1.686339e-15 -9.180000e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "2.836776e+00 -8.730699e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "5.395869e+00 -7.426776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "7.426776e+00 -5.395869e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "8.730699e+00 -2.836776e+00 1.436068e+00 " << std::endl;
  *pattern_stream << "384" << std::endl;
  *pattern_stream << "2 1 " << std::endl;
  *pattern_stream << "3 1 " << std::endl;
  *pattern_stream << "3 2 " << std::endl;
  *pattern_stream << "4 0 " << std::endl;
  *pattern_stream << "4 1 " << std::endl;
  *pattern_stream << "4 2 " << std::endl;
  *pattern_stream << "4 3 " << std::endl;
  *pattern_stream << "5 1 " << std::endl;
  *pattern_stream << "5 2 " << std::endl;
  *pattern_stream << "5 3 " << std::endl;
  *pattern_stream << "5 4 " << std::endl;
  *pattern_stream << "6 1 " << std::endl;
  *pattern_stream << "6 2 " << std::endl;
  *pattern_stream << "6 3 " << std::endl;
  *pattern_stream << "6 4 " << std::endl;
  *pattern_stream << "6 5 " << std::endl;
  *pattern_stream << "7 1 " << std::endl;
  *pattern_stream << "7 2 " << std::endl;
  *pattern_stream << "7 6 " << std::endl;
  *pattern_stream << "8 3 " << std::endl;
  *pattern_stream << "8 6 " << std::endl;
  *pattern_stream << "8 7 " << std::endl;
  *pattern_stream << "9 0 " << std::endl;
  *pattern_stream << "9 1 " << std::endl;
  *pattern_stream << "9 3 " << std::endl;
  *pattern_stream << "9 7 " << std::endl;
  *pattern_stream << "9 8 " << std::endl;
  *pattern_stream << "10 2 " << std::endl;
  *pattern_stream << "10 4 " << std::endl;
  *pattern_stream << "10 8 " << std::endl;
  *pattern_stream << "10 9 " << std::endl;
  *pattern_stream << "11 2 " << std::endl;
  *pattern_stream << "11 3 " << std::endl;
  *pattern_stream << "11 5 " << std::endl;
  *pattern_stream << "11 9 " << std::endl;
  *pattern_stream << "11 10 " << std::endl;
  *pattern_stream << "12 3 " << std::endl;
  *pattern_stream << "12 4 " << std::endl;
  *pattern_stream << "12 5 " << std::endl;
  *pattern_stream << "12 10 " << std::endl;
  *pattern_stream << "12 11 " << std::endl;
  *pattern_stream << "13 3 " << std::endl;
  *pattern_stream << "13 5 " << std::endl;
  *pattern_stream << "13 6 " << std::endl;
  *pattern_stream << "13 11 " << std::endl;
  *pattern_stream << "13 12 " << std::endl;
  *pattern_stream << "14 4 " << std::endl;
  *pattern_stream << "14 6 " << std::endl;
  *pattern_stream << "14 12 " << std::endl;
  *pattern_stream << "14 13 " << std::endl;
  *pattern_stream << "15 0 " << std::endl;
  *pattern_stream << "15 1 " << std::endl;
  *pattern_stream << "15 5 " << std::endl;
  *pattern_stream << "15 7 " << std::endl;
  *pattern_stream << "15 13 " << std::endl;
  *pattern_stream << "15 14 " << std::endl;
  *pattern_stream << "16 1 " << std::endl;
  *pattern_stream << "16 5 " << std::endl;
  *pattern_stream << "16 6 " << std::endl;
  *pattern_stream << "16 7 " << std::endl;
  *pattern_stream << "16 8 " << std::endl;
  *pattern_stream << "16 14 " << std::endl;
  *pattern_stream << "16 15 " << std::endl;
  *pattern_stream << "17 1 " << std::endl;
  *pattern_stream << "17 7 " << std::endl;
  *pattern_stream << "17 8 " << std::endl;
  *pattern_stream << "17 16 " << std::endl;
  *pattern_stream << "18 1 " << std::endl;
  *pattern_stream << "18 2 " << std::endl;
  *pattern_stream << "18 7 " << std::endl;
  *pattern_stream << "18 8 " << std::endl;
  *pattern_stream << "18 9 " << std::endl;
  *pattern_stream << "18 17 " << std::endl;
  *pattern_stream << "19 2 " << std::endl;
  *pattern_stream << "19 7 " << std::endl;
  *pattern_stream << "19 8 " << std::endl;
  *pattern_stream << "19 9 " << std::endl;
  *pattern_stream << "19 10 " << std::endl;
  *pattern_stream << "19 17 " << std::endl;
  *pattern_stream << "19 18 " << std::endl;
  *pattern_stream << "20 2 " << std::endl;
  *pattern_stream << "20 8 " << std::endl;
  *pattern_stream << "20 9 " << std::endl;
  *pattern_stream << "20 10 " << std::endl;
  *pattern_stream << "20 18 " << std::endl;
  *pattern_stream << "20 19 " << std::endl;
  *pattern_stream << "21 3 " << std::endl;
  *pattern_stream << "21 9 " << std::endl;
  *pattern_stream << "21 10 " << std::endl;
  *pattern_stream << "21 11 " << std::endl;
  *pattern_stream << "21 19 " << std::endl;
  *pattern_stream << "21 20 " << std::endl;
  *pattern_stream << "22 3 " << std::endl;
  *pattern_stream << "22 9 " << std::endl;
  *pattern_stream << "22 10 " << std::endl;
  *pattern_stream << "22 11 " << std::endl;
  *pattern_stream << "22 12 " << std::endl;
  *pattern_stream << "22 20 " << std::endl;
  *pattern_stream << "22 21 " << std::endl;
  *pattern_stream << "23 3 " << std::endl;
  *pattern_stream << "23 4 " << std::endl;
  *pattern_stream << "23 10 " << std::endl;
  *pattern_stream << "23 11 " << std::endl;
  *pattern_stream << "23 12 " << std::endl;
  *pattern_stream << "23 21 " << std::endl;
  *pattern_stream << "23 22 " << std::endl;
  *pattern_stream << "24 4 " << std::endl;
  *pattern_stream << "24 11 " << std::endl;
  *pattern_stream << "24 12 " << std::endl;
  *pattern_stream << "24 13 " << std::endl;
  *pattern_stream << "24 22 " << std::endl;
  *pattern_stream << "24 23 " << std::endl;
  *pattern_stream << "25 5 " << std::endl;
  *pattern_stream << "25 12 " << std::endl;
  *pattern_stream << "25 13 " << std::endl;
  *pattern_stream << "25 14 " << std::endl;
  *pattern_stream << "25 23 " << std::endl;
  *pattern_stream << "25 24 " << std::endl;
  *pattern_stream << "26 5 " << std::endl;
  *pattern_stream << "26 12 " << std::endl;
  *pattern_stream << "26 13 " << std::endl;
  *pattern_stream << "26 14 " << std::endl;
  *pattern_stream << "26 15 " << std::endl;
  *pattern_stream << "26 24 " << std::endl;
  *pattern_stream << "26 25 " << std::endl;
  *pattern_stream << "27 5 " << std::endl;
  *pattern_stream << "27 13 " << std::endl;
  *pattern_stream << "27 14 " << std::endl;
  *pattern_stream << "27 15 " << std::endl;
  *pattern_stream << "27 25 " << std::endl;
  *pattern_stream << "27 26 " << std::endl;
  *pattern_stream << "28 6 " << std::endl;
  *pattern_stream << "28 14 " << std::endl;
  *pattern_stream << "28 15 " << std::endl;
  *pattern_stream << "28 16 " << std::endl;
  *pattern_stream << "28 26 " << std::endl;
  *pattern_stream << "28 27 " << std::endl;
  *pattern_stream << "29 6 " << std::endl;
  *pattern_stream << "29 7 " << std::endl;
  *pattern_stream << "29 14 " << std::endl;
  *pattern_stream << "29 15 " << std::endl;
  *pattern_stream << "29 16 " << std::endl;
  *pattern_stream << "29 17 " << std::endl;
  *pattern_stream << "29 27 " << std::endl;
  *pattern_stream << "29 28 " << std::endl;
  *pattern_stream << "30 1 " << std::endl;
  *pattern_stream << "30 6 " << std::endl;
  *pattern_stream << "30 7 " << std::endl;
  *pattern_stream << "30 15 " << std::endl;
  *pattern_stream << "30 16 " << std::endl;
  *pattern_stream << "30 17 " << std::endl;
  *pattern_stream << "30 18 " << std::endl;
  *pattern_stream << "30 28 " << std::endl;
  *pattern_stream << "30 29 " << std::endl;
  *pattern_stream << "31 7 " << std::endl;
  *pattern_stream << "31 17 " << std::endl;
  *pattern_stream << "31 18 " << std::endl;
  *pattern_stream << "31 30 " << std::endl;
  *pattern_stream << "32 17 " << std::endl;
  *pattern_stream << "32 18 " << std::endl;
  *pattern_stream << "32 19 " << std::endl;
  *pattern_stream << "32 30 " << std::endl;
  *pattern_stream << "32 31 " << std::endl;
  *pattern_stream << "33 8 " << std::endl;
  *pattern_stream << "33 9 " << std::endl;
  *pattern_stream << "33 17 " << std::endl;
  *pattern_stream << "33 18 " << std::endl;
  *pattern_stream << "33 19 " << std::endl;
  *pattern_stream << "33 20 " << std::endl;
  *pattern_stream << "33 31 " << std::endl;
  *pattern_stream << "33 32 " << std::endl;
  *pattern_stream << "34 9 " << std::endl;
  *pattern_stream << "34 18 " << std::endl;
  *pattern_stream << "34 19 " << std::endl;
  *pattern_stream << "34 20 " << std::endl;
  *pattern_stream << "34 21 " << std::endl;
  *pattern_stream << "34 32 " << std::endl;
  *pattern_stream << "34 33 " << std::endl;
  *pattern_stream << "35 9 " << std::endl;
  *pattern_stream << "35 10 " << std::endl;
  *pattern_stream << "35 19 " << std::endl;
  *pattern_stream << "35 20 " << std::endl;
  *pattern_stream << "35 21 " << std::endl;
  *pattern_stream << "35 22 " << std::endl;
  *pattern_stream << "35 33 " << std::endl;
  *pattern_stream << "35 34 " << std::endl;
  *pattern_stream << "36 10 " << std::endl;
  *pattern_stream << "36 11 " << std::endl;
  *pattern_stream << "36 20 " << std::endl;
  *pattern_stream << "36 21 " << std::endl;
  *pattern_stream << "36 22 " << std::endl;
  *pattern_stream << "36 23 " << std::endl;
  *pattern_stream << "36 34 " << std::endl;
  *pattern_stream << "36 35 " << std::endl;
  *pattern_stream << "37 11 " << std::endl;
  *pattern_stream << "37 21 " << std::endl;
  *pattern_stream << "37 22 " << std::endl;
  *pattern_stream << "37 23 " << std::endl;
  *pattern_stream << "37 24 " << std::endl;
  *pattern_stream << "37 35 " << std::endl;
  *pattern_stream << "37 36 " << std::endl;
  *pattern_stream << "38 11 " << std::endl;
  *pattern_stream << "38 12 " << std::endl;
  *pattern_stream << "38 22 " << std::endl;
  *pattern_stream << "38 23 " << std::endl;
  *pattern_stream << "38 24 " << std::endl;
  *pattern_stream << "38 25 " << std::endl;
  *pattern_stream << "38 36 " << std::endl;
  *pattern_stream << "38 37 " << std::endl;
  *pattern_stream << "39 12 " << std::endl;
  *pattern_stream << "39 13 " << std::endl;
  *pattern_stream << "39 23 " << std::endl;
  *pattern_stream << "39 24 " << std::endl;
  *pattern_stream << "39 25 " << std::endl;
  *pattern_stream << "39 26 " << std::endl;
  *pattern_stream << "39 37 " << std::endl;
  *pattern_stream << "39 38 " << std::endl;
  *pattern_stream << "40 13 " << std::endl;
  *pattern_stream << "40 24 " << std::endl;
  *pattern_stream << "40 25 " << std::endl;
  *pattern_stream << "40 26 " << std::endl;
  *pattern_stream << "40 27 " << std::endl;
  *pattern_stream << "40 38 " << std::endl;
  *pattern_stream << "40 39 " << std::endl;
  *pattern_stream << "41 13 " << std::endl;
  *pattern_stream << "41 14 " << std::endl;
  *pattern_stream << "41 25 " << std::endl;
  *pattern_stream << "41 26 " << std::endl;
  *pattern_stream << "41 27 " << std::endl;
  *pattern_stream << "41 28 " << std::endl;
  *pattern_stream << "41 39 " << std::endl;
  *pattern_stream << "41 40 " << std::endl;
  *pattern_stream << "42 14 " << std::endl;
  *pattern_stream << "42 15 " << std::endl;
  *pattern_stream << "42 26 " << std::endl;
  *pattern_stream << "42 27 " << std::endl;
  *pattern_stream << "42 28 " << std::endl;
  *pattern_stream << "42 29 " << std::endl;
  *pattern_stream << "42 40 " << std::endl;
  *pattern_stream << "42 41 " << std::endl;
  *pattern_stream << "43 15 " << std::endl;
  *pattern_stream << "43 27 " << std::endl;
  *pattern_stream << "43 28 " << std::endl;
  *pattern_stream << "43 29 " << std::endl;
  *pattern_stream << "43 30 " << std::endl;
  *pattern_stream << "43 41 " << std::endl;
  *pattern_stream << "43 42 " << std::endl;
  *pattern_stream << "44 15 " << std::endl;
  *pattern_stream << "44 16 " << std::endl;
  *pattern_stream << "44 17 " << std::endl;
  *pattern_stream << "44 28 " << std::endl;
  *pattern_stream << "44 29 " << std::endl;
  *pattern_stream << "44 30 " << std::endl;
  *pattern_stream << "44 31 " << std::endl;
  *pattern_stream << "44 42 " << std::endl;
  *pattern_stream << "44 43 " << std::endl;
  *pattern_stream << "45 16 " << std::endl;
  *pattern_stream << "45 17 " << std::endl;
  *pattern_stream << "45 18 " << std::endl;
  *pattern_stream << "45 29 " << std::endl;
  *pattern_stream << "45 30 " << std::endl;
  *pattern_stream << "45 31 " << std::endl;
  *pattern_stream << "45 32 " << std::endl;
  *pattern_stream << "45 43 " << std::endl;
  *pattern_stream << "45 44 " << std::endl;
  *pattern_stream << "46 17 " << std::endl;
  *pattern_stream << "46 31 " << std::endl;
  *pattern_stream << "46 32 " << std::endl;
  *pattern_stream << "46 45 " << std::endl;
  *pattern_stream << "47 18 " << std::endl;
  *pattern_stream << "47 31 " << std::endl;
  *pattern_stream << "47 32 " << std::endl;
  *pattern_stream << "47 33 " << std::endl;
  *pattern_stream << "47 46 " << std::endl;
  *pattern_stream << "48 31 " << std::endl;
  *pattern_stream << "48 32 " << std::endl;
  *pattern_stream << "48 33 " << std::endl;
  *pattern_stream << "48 34 " << std::endl;
  *pattern_stream << "48 46 " << std::endl;
  *pattern_stream << "48 47 " << std::endl;
  *pattern_stream << "49 19 " << std::endl;
  *pattern_stream << "49 32 " << std::endl;
  *pattern_stream << "49 33 " << std::endl;
  *pattern_stream << "49 34 " << std::endl;
  *pattern_stream << "49 47 " << std::endl;
  *pattern_stream << "49 48 " << std::endl;
  *pattern_stream << "50 20 " << std::endl;
  *pattern_stream << "50 33 " << std::endl;
  *pattern_stream << "50 34 " << std::endl;
  *pattern_stream << "50 35 " << std::endl;
  *pattern_stream << "50 48 " << std::endl;
  *pattern_stream << "50 49 " << std::endl;
  *pattern_stream << "51 34 " << std::endl;
  *pattern_stream << "51 35 " << std::endl;
  *pattern_stream << "51 36 " << std::endl;
  *pattern_stream << "51 49 " << std::endl;
  *pattern_stream << "51 50 " << std::endl;
  *pattern_stream << "52 21 " << std::endl;
  *pattern_stream << "52 34 " << std::endl;
  *pattern_stream << "52 35 " << std::endl;
  *pattern_stream << "52 36 " << std::endl;
  *pattern_stream << "52 37 " << std::endl;
  *pattern_stream << "52 50 " << std::endl;
  *pattern_stream << "52 51 " << std::endl;
  *pattern_stream << "53 22 " << std::endl;
  *pattern_stream << "53 35 " << std::endl;
  *pattern_stream << "53 36 " << std::endl;
  *pattern_stream << "53 37 " << std::endl;
  *pattern_stream << "53 51 " << std::endl;
  *pattern_stream << "53 52 " << std::endl;
  *pattern_stream << "54 36 " << std::endl;
  *pattern_stream << "54 37 " << std::endl;
  *pattern_stream << "54 38 " << std::endl;
  *pattern_stream << "54 52 " << std::endl;
  *pattern_stream << "54 53 " << std::endl;
  *pattern_stream << "55 23 " << std::endl;
  *pattern_stream << "55 37 " << std::endl;
  *pattern_stream << "55 38 " << std::endl;
  *pattern_stream << "55 39 " << std::endl;
  *pattern_stream << "55 53 " << std::endl;
  *pattern_stream << "55 54 " << std::endl;
  *pattern_stream << "56 24 " << std::endl;
  *pattern_stream << "56 37 " << std::endl;
  *pattern_stream << "56 38 " << std::endl;
  *pattern_stream << "56 39 " << std::endl;
  *pattern_stream << "56 40 " << std::endl;
  *pattern_stream << "56 54 " << std::endl;
  *pattern_stream << "56 55 " << std::endl;
  *pattern_stream << "57 25 " << std::endl;
  *pattern_stream << "57 38 " << std::endl;
  *pattern_stream << "57 39 " << std::endl;
  *pattern_stream << "57 40 " << std::endl;
  *pattern_stream << "57 55 " << std::endl;
  *pattern_stream << "57 56 " << std::endl;
  *pattern_stream << "58 39 " << std::endl;
  *pattern_stream << "58 40 " << std::endl;
  *pattern_stream << "58 41 " << std::endl;
  *pattern_stream << "58 56 " << std::endl;
  *pattern_stream << "58 57 " << std::endl;
  *pattern_stream << "59 26 " << std::endl;
  *pattern_stream << "59 40 " << std::endl;
  *pattern_stream << "59 41 " << std::endl;
  *pattern_stream << "59 42 " << std::endl;
  *pattern_stream << "59 57 " << std::endl;
  *pattern_stream << "59 58 " << std::endl;
  *pattern_stream << "60 27 " << std::endl;
  *pattern_stream << "60 40 " << std::endl;
  *pattern_stream << "60 41 " << std::endl;
  *pattern_stream << "60 42 " << std::endl;
  *pattern_stream << "60 43 " << std::endl;
  *pattern_stream << "60 58 " << std::endl;
  *pattern_stream << "60 59 " << std::endl;
  *pattern_stream << "61 41 " << std::endl;
  *pattern_stream << "61 42 " << std::endl;
  *pattern_stream << "61 43 " << std::endl;
  *pattern_stream << "61 59 " << std::endl;
  *pattern_stream << "61 60 " << std::endl;
  *pattern_stream << "62 28 " << std::endl;
  *pattern_stream << "62 42 " << std::endl;
  *pattern_stream << "62 43 " << std::endl;
  *pattern_stream << "62 44 " << std::endl;
  *pattern_stream << "62 60 " << std::endl;
  *pattern_stream << "62 61 " << std::endl;
  *pattern_stream << "63 29 " << std::endl;
  *pattern_stream << "63 43 " << std::endl;
  *pattern_stream << "63 44 " << std::endl;
  *pattern_stream << "63 45 " << std::endl;
  *pattern_stream << "63 61 " << std::endl;
  *pattern_stream << "63 62 " << std::endl;
  *pattern_stream << "64 31 " << std::endl;
  *pattern_stream << "64 43 " << std::endl;
  *pattern_stream << "64 44 " << std::endl;
  *pattern_stream << "64 45 " << std::endl;
  *pattern_stream << "64 46 " << std::endl;
  *pattern_stream << "64 62 " << std::endl;
  *pattern_stream << "64 63 " << std::endl;
  *pattern_stream << "65 30 " << std::endl;
  *pattern_stream << "65 31 " << std::endl;
  *pattern_stream << "65 44 " << std::endl;
  *pattern_stream << "65 45 " << std::endl;
  *pattern_stream << "65 46 " << std::endl;
  *pattern_stream << "65 47 " << std::endl;
  *pattern_stream << "65 63 " << std::endl;
  *pattern_stream << "65 64 " << std::endl;
  *pattern_stream << "856" << std::endl;
  *pattern_stream << "1 0 " << std::endl;
  *pattern_stream << "2 0 " << std::endl;
  *pattern_stream << "2 1 " << std::endl;
  *pattern_stream << "3 0 " << std::endl;
  *pattern_stream << "3 1 " << std::endl;
  *pattern_stream << "3 2 " << std::endl;
  *pattern_stream << "4 0 " << std::endl;
  *pattern_stream << "4 1 " << std::endl;
  *pattern_stream << "4 2 " << std::endl;
  *pattern_stream << "4 3 " << std::endl;
  *pattern_stream << "5 0 " << std::endl;
  *pattern_stream << "5 1 " << std::endl;
  *pattern_stream << "5 2 " << std::endl;
  *pattern_stream << "5 3 " << std::endl;
  *pattern_stream << "5 4 " << std::endl;
  *pattern_stream << "6 0 " << std::endl;
  *pattern_stream << "6 1 " << std::endl;
  *pattern_stream << "6 2 " << std::endl;
  *pattern_stream << "6 3 " << std::endl;
  *pattern_stream << "6 4 " << std::endl;
  *pattern_stream << "6 5 " << std::endl;
  *pattern_stream << "7 0 " << std::endl;
  *pattern_stream << "7 1 " << std::endl;
  *pattern_stream << "7 2 " << std::endl;
  *pattern_stream << "7 3 " << std::endl;
  *pattern_stream << "7 4 " << std::endl;
  *pattern_stream << "7 5 " << std::endl;
  *pattern_stream << "7 6 " << std::endl;
  *pattern_stream << "8 0 " << std::endl;
  *pattern_stream << "8 1 " << std::endl;
  *pattern_stream << "8 2 " << std::endl;
  *pattern_stream << "8 3 " << std::endl;
  *pattern_stream << "8 4 " << std::endl;
  *pattern_stream << "8 5 " << std::endl;
  *pattern_stream << "8 6 " << std::endl;
  *pattern_stream << "8 7 " << std::endl;
  *pattern_stream << "9 0 " << std::endl;
  *pattern_stream << "9 1 " << std::endl;
  *pattern_stream << "9 2 " << std::endl;
  *pattern_stream << "9 3 " << std::endl;
  *pattern_stream << "9 4 " << std::endl;
  *pattern_stream << "9 5 " << std::endl;
  *pattern_stream << "9 6 " << std::endl;
  *pattern_stream << "9 7 " << std::endl;
  *pattern_stream << "9 8 " << std::endl;
  *pattern_stream << "10 0 " << std::endl;
  *pattern_stream << "10 1 " << std::endl;
  *pattern_stream << "10 2 " << std::endl;
  *pattern_stream << "10 3 " << std::endl;
  *pattern_stream << "10 4 " << std::endl;
  *pattern_stream << "10 5 " << std::endl;
  *pattern_stream << "10 6 " << std::endl;
  *pattern_stream << "10 7 " << std::endl;
  *pattern_stream << "10 8 " << std::endl;
  *pattern_stream << "10 9 " << std::endl;
  *pattern_stream << "11 0 " << std::endl;
  *pattern_stream << "11 1 " << std::endl;
  *pattern_stream << "11 2 " << std::endl;
  *pattern_stream << "11 3 " << std::endl;
  *pattern_stream << "11 4 " << std::endl;
  *pattern_stream << "11 5 " << std::endl;
  *pattern_stream << "11 6 " << std::endl;
  *pattern_stream << "11 7 " << std::endl;
  *pattern_stream << "11 8 " << std::endl;
  *pattern_stream << "11 9 " << std::endl;
  *pattern_stream << "11 10 " << std::endl;
  *pattern_stream << "12 0 " << std::endl;
  *pattern_stream << "12 1 " << std::endl;
  *pattern_stream << "12 2 " << std::endl;
  *pattern_stream << "12 3 " << std::endl;
  *pattern_stream << "12 4 " << std::endl;
  *pattern_stream << "12 5 " << std::endl;
  *pattern_stream << "12 6 " << std::endl;
  *pattern_stream << "12 8 " << std::endl;
  *pattern_stream << "12 9 " << std::endl;
  *pattern_stream << "12 10 " << std::endl;
  *pattern_stream << "12 11 " << std::endl;
  *pattern_stream << "13 0 " << std::endl;
  *pattern_stream << "13 1 " << std::endl;
  *pattern_stream << "13 2 " << std::endl;
  *pattern_stream << "13 3 " << std::endl;
  *pattern_stream << "13 4 " << std::endl;
  *pattern_stream << "13 5 " << std::endl;
  *pattern_stream << "13 6 " << std::endl;
  *pattern_stream << "13 7 " << std::endl;
  *pattern_stream << "13 9 " << std::endl;
  *pattern_stream << "13 10 " << std::endl;
  *pattern_stream << "13 11 " << std::endl;
  *pattern_stream << "13 12 " << std::endl;
  *pattern_stream << "14 0 " << std::endl;
  *pattern_stream << "14 1 " << std::endl;
  *pattern_stream << "14 2 " << std::endl;
  *pattern_stream << "14 3 " << std::endl;
  *pattern_stream << "14 4 " << std::endl;
  *pattern_stream << "14 5 " << std::endl;
  *pattern_stream << "14 6 " << std::endl;
  *pattern_stream << "14 7 " << std::endl;
  *pattern_stream << "14 8 " << std::endl;
  *pattern_stream << "14 10 " << std::endl;
  *pattern_stream << "14 11 " << std::endl;
  *pattern_stream << "14 12 " << std::endl;
  *pattern_stream << "14 13 " << std::endl;
  *pattern_stream << "15 0 " << std::endl;
  *pattern_stream << "15 1 " << std::endl;
  *pattern_stream << "15 2 " << std::endl;
  *pattern_stream << "15 3 " << std::endl;
  *pattern_stream << "15 4 " << std::endl;
  *pattern_stream << "15 5 " << std::endl;
  *pattern_stream << "15 6 " << std::endl;
  *pattern_stream << "15 7 " << std::endl;
  *pattern_stream << "15 8 " << std::endl;
  *pattern_stream << "15 9 " << std::endl;
  *pattern_stream << "15 11 " << std::endl;
  *pattern_stream << "15 12 " << std::endl;
  *pattern_stream << "15 13 " << std::endl;
  *pattern_stream << "15 14 " << std::endl;
  *pattern_stream << "16 0 " << std::endl;
  *pattern_stream << "16 1 " << std::endl;
  *pattern_stream << "16 2 " << std::endl;
  *pattern_stream << "16 3 " << std::endl;
  *pattern_stream << "16 4 " << std::endl;
  *pattern_stream << "16 5 " << std::endl;
  *pattern_stream << "16 6 " << std::endl;
  *pattern_stream << "16 7 " << std::endl;
  *pattern_stream << "16 8 " << std::endl;
  *pattern_stream << "16 9 " << std::endl;
  *pattern_stream << "16 10 " << std::endl;
  *pattern_stream << "16 12 " << std::endl;
  *pattern_stream << "16 13 " << std::endl;
  *pattern_stream << "16 14 " << std::endl;
  *pattern_stream << "16 15 " << std::endl;
  *pattern_stream << "17 0 " << std::endl;
  *pattern_stream << "17 1 " << std::endl;
  *pattern_stream << "17 2 " << std::endl;
  *pattern_stream << "17 6 " << std::endl;
  *pattern_stream << "17 7 " << std::endl;
  *pattern_stream << "17 8 " << std::endl;
  *pattern_stream << "17 9 " << std::endl;
  *pattern_stream << "17 15 " << std::endl;
  *pattern_stream << "17 16 " << std::endl;
  *pattern_stream << "18 0 " << std::endl;
  *pattern_stream << "18 1 " << std::endl;
  *pattern_stream << "18 2 " << std::endl;
  *pattern_stream << "18 3 " << std::endl;
  *pattern_stream << "18 6 " << std::endl;
  *pattern_stream << "18 7 " << std::endl;
  *pattern_stream << "18 8 " << std::endl;
  *pattern_stream << "18 9 " << std::endl;
  *pattern_stream << "18 10 " << std::endl;
  *pattern_stream << "18 15 " << std::endl;
  *pattern_stream << "18 16 " << std::endl;
  *pattern_stream << "18 17 " << std::endl;
  *pattern_stream << "19 0 " << std::endl;
  *pattern_stream << "19 1 " << std::endl;
  *pattern_stream << "19 2 " << std::endl;
  *pattern_stream << "19 3 " << std::endl;
  *pattern_stream << "19 6 " << std::endl;
  *pattern_stream << "19 7 " << std::endl;
  *pattern_stream << "19 8 " << std::endl;
  *pattern_stream << "19 9 " << std::endl;
  *pattern_stream << "19 10 " << std::endl;
  *pattern_stream << "19 11 " << std::endl;
  *pattern_stream << "19 16 " << std::endl;
  *pattern_stream << "19 17 " << std::endl;
  *pattern_stream << "19 18 " << std::endl;
  *pattern_stream << "20 0 " << std::endl;
  *pattern_stream << "20 1 " << std::endl;
  *pattern_stream << "20 2 " << std::endl;
  *pattern_stream << "20 3 " << std::endl;
  *pattern_stream << "20 4 " << std::endl;
  *pattern_stream << "20 7 " << std::endl;
  *pattern_stream << "20 8 " << std::endl;
  *pattern_stream << "20 9 " << std::endl;
  *pattern_stream << "20 10 " << std::endl;
  *pattern_stream << "20 11 " << std::endl;
  *pattern_stream << "20 12 " << std::endl;
  *pattern_stream << "20 17 " << std::endl;
  *pattern_stream << "20 18 " << std::endl;
  *pattern_stream << "20 19 " << std::endl;
  *pattern_stream << "21 0 " << std::endl;
  *pattern_stream << "21 1 " << std::endl;
  *pattern_stream << "21 2 " << std::endl;
  *pattern_stream << "21 3 " << std::endl;
  *pattern_stream << "21 4 " << std::endl;
  *pattern_stream << "21 7 " << std::endl;
  *pattern_stream << "21 8 " << std::endl;
  *pattern_stream << "21 9 " << std::endl;
  *pattern_stream << "21 10 " << std::endl;
  *pattern_stream << "21 11 " << std::endl;
  *pattern_stream << "21 12 " << std::endl;
  *pattern_stream << "21 18 " << std::endl;
  *pattern_stream << "21 19 " << std::endl;
  *pattern_stream << "21 20 " << std::endl;
  *pattern_stream << "22 0 " << std::endl;
  *pattern_stream << "22 2 " << std::endl;
  *pattern_stream << "22 3 " << std::endl;
  *pattern_stream << "22 4 " << std::endl;
  *pattern_stream << "22 5 " << std::endl;
  *pattern_stream << "22 8 " << std::endl;
  *pattern_stream << "22 9 " << std::endl;
  *pattern_stream << "22 10 " << std::endl;
  *pattern_stream << "22 11 " << std::endl;
  *pattern_stream << "22 12 " << std::endl;
  *pattern_stream << "22 13 " << std::endl;
  *pattern_stream << "22 19 " << std::endl;
  *pattern_stream << "22 20 " << std::endl;
  *pattern_stream << "22 21 " << std::endl;
  *pattern_stream << "23 0 " << std::endl;
  *pattern_stream << "23 2 " << std::endl;
  *pattern_stream << "23 3 " << std::endl;
  *pattern_stream << "23 4 " << std::endl;
  *pattern_stream << "23 5 " << std::endl;
  *pattern_stream << "23 9 " << std::endl;
  *pattern_stream << "23 10 " << std::endl;
  *pattern_stream << "23 11 " << std::endl;
  *pattern_stream << "23 12 " << std::endl;
  *pattern_stream << "23 13 " << std::endl;
  *pattern_stream << "23 14 " << std::endl;
  *pattern_stream << "23 20 " << std::endl;
  *pattern_stream << "23 21 " << std::endl;
  *pattern_stream << "23 22 " << std::endl;
  *pattern_stream << "24 0 " << std::endl;
  *pattern_stream << "24 3 " << std::endl;
  *pattern_stream << "24 4 " << std::endl;
  *pattern_stream << "24 5 " << std::endl;
  *pattern_stream << "24 10 " << std::endl;
  *pattern_stream << "24 11 " << std::endl;
  *pattern_stream << "24 12 " << std::endl;
  *pattern_stream << "24 13 " << std::endl;
  *pattern_stream << "24 14 " << std::endl;
  *pattern_stream << "24 21 " << std::endl;
  *pattern_stream << "24 22 " << std::endl;
  *pattern_stream << "24 23 " << std::endl;
  *pattern_stream << "25 0 " << std::endl;
  *pattern_stream << "25 3 " << std::endl;
  *pattern_stream << "25 4 " << std::endl;
  *pattern_stream << "25 5 " << std::endl;
  *pattern_stream << "25 6 " << std::endl;
  *pattern_stream << "25 10 " << std::endl;
  *pattern_stream << "25 11 " << std::endl;
  *pattern_stream << "25 12 " << std::endl;
  *pattern_stream << "25 13 " << std::endl;
  *pattern_stream << "25 14 " << std::endl;
  *pattern_stream << "25 15 " << std::endl;
  *pattern_stream << "25 22 " << std::endl;
  *pattern_stream << "25 23 " << std::endl;
  *pattern_stream << "25 24 " << std::endl;
  *pattern_stream << "26 0 " << std::endl;
  *pattern_stream << "26 3 " << std::endl;
  *pattern_stream << "26 4 " << std::endl;
  *pattern_stream << "26 5 " << std::endl;
  *pattern_stream << "26 6 " << std::endl;
  *pattern_stream << "26 11 " << std::endl;
  *pattern_stream << "26 12 " << std::endl;
  *pattern_stream << "26 13 " << std::endl;
  *pattern_stream << "26 14 " << std::endl;
  *pattern_stream << "26 15 " << std::endl;
  *pattern_stream << "26 16 " << std::endl;
  *pattern_stream << "26 23 " << std::endl;
  *pattern_stream << "26 24 " << std::endl;
  *pattern_stream << "26 25 " << std::endl;
  *pattern_stream << "27 0 " << std::endl;
  *pattern_stream << "27 1 " << std::endl;
  *pattern_stream << "27 4 " << std::endl;
  *pattern_stream << "27 5 " << std::endl;
  *pattern_stream << "27 6 " << std::endl;
  *pattern_stream << "27 7 " << std::endl;
  *pattern_stream << "27 12 " << std::endl;
  *pattern_stream << "27 13 " << std::endl;
  *pattern_stream << "27 14 " << std::endl;
  *pattern_stream << "27 15 " << std::endl;
  *pattern_stream << "27 16 " << std::endl;
  *pattern_stream << "27 24 " << std::endl;
  *pattern_stream << "27 25 " << std::endl;
  *pattern_stream << "27 26 " << std::endl;
  *pattern_stream << "28 0 " << std::endl;
  *pattern_stream << "28 1 " << std::endl;
  *pattern_stream << "28 4 " << std::endl;
  *pattern_stream << "28 5 " << std::endl;
  *pattern_stream << "28 6 " << std::endl;
  *pattern_stream << "28 7 " << std::endl;
  *pattern_stream << "28 12 " << std::endl;
  *pattern_stream << "28 13 " << std::endl;
  *pattern_stream << "28 14 " << std::endl;
  *pattern_stream << "28 15 " << std::endl;
  *pattern_stream << "28 16 " << std::endl;
  *pattern_stream << "28 17 " << std::endl;
  *pattern_stream << "28 25 " << std::endl;
  *pattern_stream << "28 26 " << std::endl;
  *pattern_stream << "28 27 " << std::endl;
  *pattern_stream << "29 0 " << std::endl;
  *pattern_stream << "29 1 " << std::endl;
  *pattern_stream << "29 2 " << std::endl;
  *pattern_stream << "29 5 " << std::endl;
  *pattern_stream << "29 6 " << std::endl;
  *pattern_stream << "29 7 " << std::endl;
  *pattern_stream << "29 8 " << std::endl;
  *pattern_stream << "29 13 " << std::endl;
  *pattern_stream << "29 14 " << std::endl;
  *pattern_stream << "29 15 " << std::endl;
  *pattern_stream << "29 16 " << std::endl;
  *pattern_stream << "29 17 " << std::endl;
  *pattern_stream << "29 18 " << std::endl;
  *pattern_stream << "29 26 " << std::endl;
  *pattern_stream << "29 27 " << std::endl;
  *pattern_stream << "29 28 " << std::endl;
  *pattern_stream << "30 0 " << std::endl;
  *pattern_stream << "30 1 " << std::endl;
  *pattern_stream << "30 2 " << std::endl;
  *pattern_stream << "30 5 " << std::endl;
  *pattern_stream << "30 6 " << std::endl;
  *pattern_stream << "30 7 " << std::endl;
  *pattern_stream << "30 8 " << std::endl;
  *pattern_stream << "30 9 " << std::endl;
  *pattern_stream << "30 14 " << std::endl;
  *pattern_stream << "30 15 " << std::endl;
  *pattern_stream << "30 16 " << std::endl;
  *pattern_stream << "30 17 " << std::endl;
  *pattern_stream << "30 18 " << std::endl;
  *pattern_stream << "30 19 " << std::endl;
  *pattern_stream << "30 27 " << std::endl;
  *pattern_stream << "30 28 " << std::endl;
  *pattern_stream << "30 29 " << std::endl;
  *pattern_stream << "31 1 " << std::endl;
  *pattern_stream << "31 2 " << std::endl;
  *pattern_stream << "31 6 " << std::endl;
  *pattern_stream << "31 7 " << std::endl;
  *pattern_stream << "31 8 " << std::endl;
  *pattern_stream << "31 9 " << std::endl;
  *pattern_stream << "31 15 " << std::endl;
  *pattern_stream << "31 16 " << std::endl;
  *pattern_stream << "31 17 " << std::endl;
  *pattern_stream << "31 18 " << std::endl;
  *pattern_stream << "31 19 " << std::endl;
  *pattern_stream << "31 20 " << std::endl;
  *pattern_stream << "31 28 " << std::endl;
  *pattern_stream << "31 29 " << std::endl;
  *pattern_stream << "31 30 " << std::endl;
  *pattern_stream << "32 1 " << std::endl;
  *pattern_stream << "32 2 " << std::endl;
  *pattern_stream << "32 7 " << std::endl;
  *pattern_stream << "32 8 " << std::endl;
  *pattern_stream << "32 9 " << std::endl;
  *pattern_stream << "32 10 " << std::endl;
  *pattern_stream << "32 16 " << std::endl;
  *pattern_stream << "32 17 " << std::endl;
  *pattern_stream << "32 18 " << std::endl;
  *pattern_stream << "32 19 " << std::endl;
  *pattern_stream << "32 20 " << std::endl;
  *pattern_stream << "32 21 " << std::endl;
  *pattern_stream << "32 29 " << std::endl;
  *pattern_stream << "32 30 " << std::endl;
  *pattern_stream << "32 31 " << std::endl;
  *pattern_stream << "33 1 " << std::endl;
  *pattern_stream << "33 2 " << std::endl;
  *pattern_stream << "33 3 " << std::endl;
  *pattern_stream << "33 7 " << std::endl;
  *pattern_stream << "33 8 " << std::endl;
  *pattern_stream << "33 9 " << std::endl;
  *pattern_stream << "33 10 " << std::endl;
  *pattern_stream << "33 16 " << std::endl;
  *pattern_stream << "33 17 " << std::endl;
  *pattern_stream << "33 18 " << std::endl;
  *pattern_stream << "33 19 " << std::endl;
  *pattern_stream << "33 20 " << std::endl;
  *pattern_stream << "33 21 " << std::endl;
  *pattern_stream << "33 22 " << std::endl;
  *pattern_stream << "33 30 " << std::endl;
  *pattern_stream << "33 31 " << std::endl;
  *pattern_stream << "33 32 " << std::endl;
  *pattern_stream << "34 1 " << std::endl;
  *pattern_stream << "34 2 " << std::endl;
  *pattern_stream << "34 3 " << std::endl;
  *pattern_stream << "34 7 " << std::endl;
  *pattern_stream << "34 8 " << std::endl;
  *pattern_stream << "34 9 " << std::endl;
  *pattern_stream << "34 10 " << std::endl;
  *pattern_stream << "34 11 " << std::endl;
  *pattern_stream << "34 17 " << std::endl;
  *pattern_stream << "34 18 " << std::endl;
  *pattern_stream << "34 19 " << std::endl;
  *pattern_stream << "34 20 " << std::endl;
  *pattern_stream << "34 21 " << std::endl;
  *pattern_stream << "34 22 " << std::endl;
  *pattern_stream << "34 23 " << std::endl;
  *pattern_stream << "34 31 " << std::endl;
  *pattern_stream << "34 32 " << std::endl;
  *pattern_stream << "34 33 " << std::endl;
  *pattern_stream << "35 2 " << std::endl;
  *pattern_stream << "35 3 " << std::endl;
  *pattern_stream << "35 8 " << std::endl;
  *pattern_stream << "35 9 " << std::endl;
  *pattern_stream << "35 10 " << std::endl;
  *pattern_stream << "35 11 " << std::endl;
  *pattern_stream << "35 12 " << std::endl;
  *pattern_stream << "35 18 " << std::endl;
  *pattern_stream << "35 19 " << std::endl;
  *pattern_stream << "35 20 " << std::endl;
  *pattern_stream << "35 21 " << std::endl;
  *pattern_stream << "35 22 " << std::endl;
  *pattern_stream << "35 23 " << std::endl;
  *pattern_stream << "35 32 " << std::endl;
  *pattern_stream << "35 33 " << std::endl;
  *pattern_stream << "35 34 " << std::endl;
  *pattern_stream << "36 2 " << std::endl;
  *pattern_stream << "36 3 " << std::endl;
  *pattern_stream << "36 4 " << std::endl;
  *pattern_stream << "36 8 " << std::endl;
  *pattern_stream << "36 9 " << std::endl;
  *pattern_stream << "36 10 " << std::endl;
  *pattern_stream << "36 11 " << std::endl;
  *pattern_stream << "36 12 " << std::endl;
  *pattern_stream << "36 19 " << std::endl;
  *pattern_stream << "36 20 " << std::endl;
  *pattern_stream << "36 21 " << std::endl;
  *pattern_stream << "36 22 " << std::endl;
  *pattern_stream << "36 23 " << std::endl;
  *pattern_stream << "36 24 " << std::endl;
  *pattern_stream << "36 33 " << std::endl;
  *pattern_stream << "36 34 " << std::endl;
  *pattern_stream << "36 35 " << std::endl;
  *pattern_stream << "37 3 " << std::endl;
  *pattern_stream << "37 4 " << std::endl;
  *pattern_stream << "37 9 " << std::endl;
  *pattern_stream << "37 10 " << std::endl;
  *pattern_stream << "37 11 " << std::endl;
  *pattern_stream << "37 12 " << std::endl;
  *pattern_stream << "37 13 " << std::endl;
  *pattern_stream << "37 20 " << std::endl;
  *pattern_stream << "37 21 " << std::endl;
  *pattern_stream << "37 22 " << std::endl;
  *pattern_stream << "37 23 " << std::endl;
  *pattern_stream << "37 24 " << std::endl;
  *pattern_stream << "37 25 " << std::endl;
  *pattern_stream << "37 34 " << std::endl;
  *pattern_stream << "37 35 " << std::endl;
  *pattern_stream << "37 36 " << std::endl;
  *pattern_stream << "38 3 " << std::endl;
  *pattern_stream << "38 4 " << std::endl;
  *pattern_stream << "38 5 " << std::endl;
  *pattern_stream << "38 10 " << std::endl;
  *pattern_stream << "38 11 " << std::endl;
  *pattern_stream << "38 12 " << std::endl;
  *pattern_stream << "38 13 " << std::endl;
  *pattern_stream << "38 14 " << std::endl;
  *pattern_stream << "38 21 " << std::endl;
  *pattern_stream << "38 22 " << std::endl;
  *pattern_stream << "38 23 " << std::endl;
  *pattern_stream << "38 24 " << std::endl;
  *pattern_stream << "38 25 " << std::endl;
  *pattern_stream << "38 26 " << std::endl;
  *pattern_stream << "38 35 " << std::endl;
  *pattern_stream << "38 36 " << std::endl;
  *pattern_stream << "38 37 " << std::endl;
  *pattern_stream << "39 3 " << std::endl;
  *pattern_stream << "39 4 " << std::endl;
  *pattern_stream << "39 5 " << std::endl;
  *pattern_stream << "39 10 " << std::endl;
  *pattern_stream << "39 11 " << std::endl;
  *pattern_stream << "39 12 " << std::endl;
  *pattern_stream << "39 13 " << std::endl;
  *pattern_stream << "39 14 " << std::endl;
  *pattern_stream << "39 22 " << std::endl;
  *pattern_stream << "39 23 " << std::endl;
  *pattern_stream << "39 24 " << std::endl;
  *pattern_stream << "39 25 " << std::endl;
  *pattern_stream << "39 26 " << std::endl;
  *pattern_stream << "39 27 " << std::endl;
  *pattern_stream << "39 36 " << std::endl;
  *pattern_stream << "39 37 " << std::endl;
  *pattern_stream << "39 38 " << std::endl;
  *pattern_stream << "40 4 " << std::endl;
  *pattern_stream << "40 5 " << std::endl;
  *pattern_stream << "40 11 " << std::endl;
  *pattern_stream << "40 12 " << std::endl;
  *pattern_stream << "40 13 " << std::endl;
  *pattern_stream << "40 14 " << std::endl;
  *pattern_stream << "40 15 " << std::endl;
  *pattern_stream << "40 23 " << std::endl;
  *pattern_stream << "40 24 " << std::endl;
  *pattern_stream << "40 25 " << std::endl;
  *pattern_stream << "40 26 " << std::endl;
  *pattern_stream << "40 27 " << std::endl;
  *pattern_stream << "40 28 " << std::endl;
  *pattern_stream << "40 37 " << std::endl;
  *pattern_stream << "40 38 " << std::endl;
  *pattern_stream << "40 39 " << std::endl;
  *pattern_stream << "41 4 " << std::endl;
  *pattern_stream << "41 5 " << std::endl;
  *pattern_stream << "41 6 " << std::endl;
  *pattern_stream << "41 12 " << std::endl;
  *pattern_stream << "41 13 " << std::endl;
  *pattern_stream << "41 14 " << std::endl;
  *pattern_stream << "41 15 " << std::endl;
  *pattern_stream << "41 16 " << std::endl;
  *pattern_stream << "41 24 " << std::endl;
  *pattern_stream << "41 25 " << std::endl;
  *pattern_stream << "41 26 " << std::endl;
  *pattern_stream << "41 27 " << std::endl;
  *pattern_stream << "41 28 " << std::endl;
  *pattern_stream << "41 29 " << std::endl;
  *pattern_stream << "41 38 " << std::endl;
  *pattern_stream << "41 39 " << std::endl;
  *pattern_stream << "41 40 " << std::endl;
  *pattern_stream << "42 5 " << std::endl;
  *pattern_stream << "42 6 " << std::endl;
  *pattern_stream << "42 12 " << std::endl;
  *pattern_stream << "42 13 " << std::endl;
  *pattern_stream << "42 14 " << std::endl;
  *pattern_stream << "42 15 " << std::endl;
  *pattern_stream << "42 16 " << std::endl;
  *pattern_stream << "42 25 " << std::endl;
  *pattern_stream << "42 26 " << std::endl;
  *pattern_stream << "42 27 " << std::endl;
  *pattern_stream << "42 28 " << std::endl;
  *pattern_stream << "42 29 " << std::endl;
  *pattern_stream << "42 30 " << std::endl;
  *pattern_stream << "42 39 " << std::endl;
  *pattern_stream << "42 40 " << std::endl;
  *pattern_stream << "42 41 " << std::endl;
  *pattern_stream << "43 1 " << std::endl;
  *pattern_stream << "43 5 " << std::endl;
  *pattern_stream << "43 6 " << std::endl;
  *pattern_stream << "43 7 " << std::endl;
  *pattern_stream << "43 13 " << std::endl;
  *pattern_stream << "43 14 " << std::endl;
  *pattern_stream << "43 15 " << std::endl;
  *pattern_stream << "43 16 " << std::endl;
  *pattern_stream << "43 17 " << std::endl;
  *pattern_stream << "43 25 " << std::endl;
  *pattern_stream << "43 26 " << std::endl;
  *pattern_stream << "43 27 " << std::endl;
  *pattern_stream << "43 28 " << std::endl;
  *pattern_stream << "43 29 " << std::endl;
  *pattern_stream << "43 30 " << std::endl;
  *pattern_stream << "43 31 " << std::endl;
  *pattern_stream << "43 40 " << std::endl;
  *pattern_stream << "43 41 " << std::endl;
  *pattern_stream << "43 42 " << std::endl;
  *pattern_stream << "44 1 " << std::endl;
  *pattern_stream << "44 5 " << std::endl;
  *pattern_stream << "44 6 " << std::endl;
  *pattern_stream << "44 7 " << std::endl;
  *pattern_stream << "44 8 " << std::endl;
  *pattern_stream << "44 14 " << std::endl;
  *pattern_stream << "44 15 " << std::endl;
  *pattern_stream << "44 16 " << std::endl;
  *pattern_stream << "44 17 " << std::endl;
  *pattern_stream << "44 18 " << std::endl;
  *pattern_stream << "44 26 " << std::endl;
  *pattern_stream << "44 27 " << std::endl;
  *pattern_stream << "44 28 " << std::endl;
  *pattern_stream << "44 29 " << std::endl;
  *pattern_stream << "44 30 " << std::endl;
  *pattern_stream << "44 31 " << std::endl;
  *pattern_stream << "44 32 " << std::endl;
  *pattern_stream << "44 41 " << std::endl;
  *pattern_stream << "44 42 " << std::endl;
  *pattern_stream << "44 43 " << std::endl;
  *pattern_stream << "45 1 " << std::endl;
  *pattern_stream << "45 6 " << std::endl;
  *pattern_stream << "45 7 " << std::endl;
  *pattern_stream << "45 8 " << std::endl;
  *pattern_stream << "45 14 " << std::endl;
  *pattern_stream << "45 15 " << std::endl;
  *pattern_stream << "45 16 " << std::endl;
  *pattern_stream << "45 17 " << std::endl;
  *pattern_stream << "45 18 " << std::endl;
  *pattern_stream << "45 19 " << std::endl;
  *pattern_stream << "45 27 " << std::endl;
  *pattern_stream << "45 28 " << std::endl;
  *pattern_stream << "45 29 " << std::endl;
  *pattern_stream << "45 30 " << std::endl;
  *pattern_stream << "45 31 " << std::endl;
  *pattern_stream << "45 32 " << std::endl;
  *pattern_stream << "45 33 " << std::endl;
  *pattern_stream << "45 42 " << std::endl;
  *pattern_stream << "45 43 " << std::endl;
  *pattern_stream << "45 44 " << std::endl;
  *pattern_stream << "46 7 " << std::endl;
  *pattern_stream << "46 17 " << std::endl;
  *pattern_stream << "46 18 " << std::endl;
  *pattern_stream << "46 19 " << std::endl;
  *pattern_stream << "46 29 " << std::endl;
  *pattern_stream << "46 30 " << std::endl;
  *pattern_stream << "46 31 " << std::endl;
  *pattern_stream << "46 32 " << std::endl;
  *pattern_stream << "46 33 " << std::endl;
  *pattern_stream << "46 44 " << std::endl;
  *pattern_stream << "46 45 " << std::endl;
  *pattern_stream << "47 7 " << std::endl;
  *pattern_stream << "47 8 " << std::endl;
  *pattern_stream << "47 17 " << std::endl;
  *pattern_stream << "47 18 " << std::endl;
  *pattern_stream << "47 19 " << std::endl;
  *pattern_stream << "47 30 " << std::endl;
  *pattern_stream << "47 31 " << std::endl;
  *pattern_stream << "47 32 " << std::endl;
  *pattern_stream << "47 33 " << std::endl;
  *pattern_stream << "47 34 " << std::endl;
  *pattern_stream << "47 45 " << std::endl;
  *pattern_stream << "47 46 " << std::endl;
  *pattern_stream << "48 8 " << std::endl;
  *pattern_stream << "48 17 " << std::endl;
  *pattern_stream << "48 18 " << std::endl;
  *pattern_stream << "48 19 " << std::endl;
  *pattern_stream << "48 20 " << std::endl;
  *pattern_stream << "48 31 " << std::endl;
  *pattern_stream << "48 32 " << std::endl;
  *pattern_stream << "48 33 " << std::endl;
  *pattern_stream << "48 34 " << std::endl;
  *pattern_stream << "48 35 " << std::endl;
  *pattern_stream << "48 45 " << std::endl;
  *pattern_stream << "48 46 " << std::endl;
  *pattern_stream << "48 47 " << std::endl;
  *pattern_stream << "49 8 " << std::endl;
  *pattern_stream << "49 9 " << std::endl;
  *pattern_stream << "49 18 " << std::endl;
  *pattern_stream << "49 19 " << std::endl;
  *pattern_stream << "49 20 " << std::endl;
  *pattern_stream << "49 21 " << std::endl;
  *pattern_stream << "49 31 " << std::endl;
  *pattern_stream << "49 32 " << std::endl;
  *pattern_stream << "49 33 " << std::endl;
  *pattern_stream << "49 34 " << std::endl;
  *pattern_stream << "49 35 " << std::endl;
  *pattern_stream << "49 46 " << std::endl;
  *pattern_stream << "49 47 " << std::endl;
  *pattern_stream << "49 48 " << std::endl;
  *pattern_stream << "50 9 " << std::endl;
  *pattern_stream << "50 18 " << std::endl;
  *pattern_stream << "50 19 " << std::endl;
  *pattern_stream << "50 20 " << std::endl;
  *pattern_stream << "50 21 " << std::endl;
  *pattern_stream << "50 32 " << std::endl;
  *pattern_stream << "50 33 " << std::endl;
  *pattern_stream << "50 34 " << std::endl;
  *pattern_stream << "50 35 " << std::endl;
  *pattern_stream << "50 36 " << std::endl;
  *pattern_stream << "50 47 " << std::endl;
  *pattern_stream << "50 48 " << std::endl;
  *pattern_stream << "50 49 " << std::endl;
  *pattern_stream << "51 9 " << std::endl;
  *pattern_stream << "51 10 " << std::endl;
  *pattern_stream << "51 19 " << std::endl;
  *pattern_stream << "51 20 " << std::endl;
  *pattern_stream << "51 21 " << std::endl;
  *pattern_stream << "51 22 " << std::endl;
  *pattern_stream << "51 33 " << std::endl;
  *pattern_stream << "51 34 " << std::endl;
  *pattern_stream << "51 35 " << std::endl;
  *pattern_stream << "51 36 " << std::endl;
  *pattern_stream << "51 37 " << std::endl;
  *pattern_stream << "51 48 " << std::endl;
  *pattern_stream << "51 49 " << std::endl;
  *pattern_stream << "51 50 " << std::endl;
  *pattern_stream << "52 10 " << std::endl;
  *pattern_stream << "52 20 " << std::endl;
  *pattern_stream << "52 21 " << std::endl;
  *pattern_stream << "52 22 " << std::endl;
  *pattern_stream << "52 23 " << std::endl;
  *pattern_stream << "52 33 " << std::endl;
  *pattern_stream << "52 34 " << std::endl;
  *pattern_stream << "52 35 " << std::endl;
  *pattern_stream << "52 36 " << std::endl;
  *pattern_stream << "52 37 " << std::endl;
  *pattern_stream << "52 38 " << std::endl;
  *pattern_stream << "52 49 " << std::endl;
  *pattern_stream << "52 50 " << std::endl;
  *pattern_stream << "52 51 " << std::endl;
  *pattern_stream << "53 10 " << std::endl;
  *pattern_stream << "53 11 " << std::endl;
  *pattern_stream << "53 20 " << std::endl;
  *pattern_stream << "53 21 " << std::endl;
  *pattern_stream << "53 22 " << std::endl;
  *pattern_stream << "53 23 " << std::endl;
  *pattern_stream << "53 34 " << std::endl;
  *pattern_stream << "53 35 " << std::endl;
  *pattern_stream << "53 36 " << std::endl;
  *pattern_stream << "53 37 " << std::endl;
  *pattern_stream << "53 38 " << std::endl;
  *pattern_stream << "53 50 " << std::endl;
  *pattern_stream << "53 51 " << std::endl;
  *pattern_stream << "53 52 " << std::endl;
  *pattern_stream << "54 11 " << std::endl;
  *pattern_stream << "54 21 " << std::endl;
  *pattern_stream << "54 22 " << std::endl;
  *pattern_stream << "54 23 " << std::endl;
  *pattern_stream << "54 24 " << std::endl;
  *pattern_stream << "54 35 " << std::endl;
  *pattern_stream << "54 36 " << std::endl;
  *pattern_stream << "54 37 " << std::endl;
  *pattern_stream << "54 38 " << std::endl;
  *pattern_stream << "54 39 " << std::endl;
  *pattern_stream << "54 51 " << std::endl;
  *pattern_stream << "54 52 " << std::endl;
  *pattern_stream << "54 53 " << std::endl;
  *pattern_stream << "55 11 " << std::endl;
  *pattern_stream << "55 12 " << std::endl;
  *pattern_stream << "55 22 " << std::endl;
  *pattern_stream << "55 23 " << std::endl;
  *pattern_stream << "55 24 " << std::endl;
  *pattern_stream << "55 25 " << std::endl;
  *pattern_stream << "55 36 " << std::endl;
  *pattern_stream << "55 37 " << std::endl;
  *pattern_stream << "55 38 " << std::endl;
  *pattern_stream << "55 39 " << std::endl;
  *pattern_stream << "55 40 " << std::endl;
  *pattern_stream << "55 52 " << std::endl;
  *pattern_stream << "55 53 " << std::endl;
  *pattern_stream << "55 54 " << std::endl;
  *pattern_stream << "56 12 " << std::endl;
  *pattern_stream << "56 22 " << std::endl;
  *pattern_stream << "56 23 " << std::endl;
  *pattern_stream << "56 24 " << std::endl;
  *pattern_stream << "56 25 " << std::endl;
  *pattern_stream << "56 26 " << std::endl;
  *pattern_stream << "56 36 " << std::endl;
  *pattern_stream << "56 37 " << std::endl;
  *pattern_stream << "56 38 " << std::endl;
  *pattern_stream << "56 39 " << std::endl;
  *pattern_stream << "56 40 " << std::endl;
  *pattern_stream << "56 41 " << std::endl;
  *pattern_stream << "56 53 " << std::endl;
  *pattern_stream << "56 54 " << std::endl;
  *pattern_stream << "56 55 " << std::endl;
  *pattern_stream << "57 12 " << std::endl;
  *pattern_stream << "57 13 " << std::endl;
  *pattern_stream << "57 23 " << std::endl;
  *pattern_stream << "57 24 " << std::endl;
  *pattern_stream << "57 25 " << std::endl;
  *pattern_stream << "57 26 " << std::endl;
  *pattern_stream << "57 37 " << std::endl;
  *pattern_stream << "57 38 " << std::endl;
  *pattern_stream << "57 39 " << std::endl;
  *pattern_stream << "57 40 " << std::endl;
  *pattern_stream << "57 41 " << std::endl;
  *pattern_stream << "57 54 " << std::endl;
  *pattern_stream << "57 55 " << std::endl;
  *pattern_stream << "57 56 " << std::endl;
  *pattern_stream << "58 13 " << std::endl;
  *pattern_stream << "58 24 " << std::endl;
  *pattern_stream << "58 25 " << std::endl;
  *pattern_stream << "58 26 " << std::endl;
  *pattern_stream << "58 27 " << std::endl;
  *pattern_stream << "58 38 " << std::endl;
  *pattern_stream << "58 39 " << std::endl;
  *pattern_stream << "58 40 " << std::endl;
  *pattern_stream << "58 41 " << std::endl;
  *pattern_stream << "58 42 " << std::endl;
  *pattern_stream << "58 55 " << std::endl;
  *pattern_stream << "58 56 " << std::endl;
  *pattern_stream << "58 57 " << std::endl;
  *pattern_stream << "59 13 " << std::endl;
  *pattern_stream << "59 14 " << std::endl;
  *pattern_stream << "59 25 " << std::endl;
  *pattern_stream << "59 26 " << std::endl;
  *pattern_stream << "59 27 " << std::endl;
  *pattern_stream << "59 28 " << std::endl;
  *pattern_stream << "59 39 " << std::endl;
  *pattern_stream << "59 40 " << std::endl;
  *pattern_stream << "59 41 " << std::endl;
  *pattern_stream << "59 42 " << std::endl;
  *pattern_stream << "59 43 " << std::endl;
  *pattern_stream << "59 56 " << std::endl;
  *pattern_stream << "59 57 " << std::endl;
  *pattern_stream << "59 58 " << std::endl;
  *pattern_stream << "60 14 " << std::endl;
  *pattern_stream << "60 25 " << std::endl;
  *pattern_stream << "60 26 " << std::endl;
  *pattern_stream << "60 27 " << std::endl;
  *pattern_stream << "60 28 " << std::endl;
  *pattern_stream << "60 39 " << std::endl;
  *pattern_stream << "60 40 " << std::endl;
  *pattern_stream << "60 41 " << std::endl;
  *pattern_stream << "60 42 " << std::endl;
  *pattern_stream << "60 43 " << std::endl;
  *pattern_stream << "60 44 " << std::endl;
  *pattern_stream << "60 57 " << std::endl;
  *pattern_stream << "60 58 " << std::endl;
  *pattern_stream << "60 59 " << std::endl;
  *pattern_stream << "61 14 " << std::endl;
  *pattern_stream << "61 15 " << std::endl;
  *pattern_stream << "61 26 " << std::endl;
  *pattern_stream << "61 27 " << std::endl;
  *pattern_stream << "61 28 " << std::endl;
  *pattern_stream << "61 29 " << std::endl;
  *pattern_stream << "61 40 " << std::endl;
  *pattern_stream << "61 41 " << std::endl;
  *pattern_stream << "61 42 " << std::endl;
  *pattern_stream << "61 43 " << std::endl;
  *pattern_stream << "61 44 " << std::endl;
  *pattern_stream << "61 58 " << std::endl;
  *pattern_stream << "61 59 " << std::endl;
  *pattern_stream << "61 60 " << std::endl;
  *pattern_stream << "62 15 " << std::endl;
  *pattern_stream << "62 27 " << std::endl;
  *pattern_stream << "62 28 " << std::endl;
  *pattern_stream << "62 29 " << std::endl;
  *pattern_stream << "62 30 " << std::endl;
  *pattern_stream << "62 41 " << std::endl;
  *pattern_stream << "62 42 " << std::endl;
  *pattern_stream << "62 43 " << std::endl;
  *pattern_stream << "62 44 " << std::endl;
  *pattern_stream << "62 45 " << std::endl;
  *pattern_stream << "62 59 " << std::endl;
  *pattern_stream << "62 60 " << std::endl;
  *pattern_stream << "62 61 " << std::endl;
  *pattern_stream << "63 15 " << std::endl;
  *pattern_stream << "63 16 " << std::endl;
  *pattern_stream << "63 27 " << std::endl;
  *pattern_stream << "63 28 " << std::endl;
  *pattern_stream << "63 29 " << std::endl;
  *pattern_stream << "63 30 " << std::endl;
  *pattern_stream << "63 31 " << std::endl;
  *pattern_stream << "63 42 " << std::endl;
  *pattern_stream << "63 43 " << std::endl;
  *pattern_stream << "63 44 " << std::endl;
  *pattern_stream << "63 45 " << std::endl;
  *pattern_stream << "63 46 " << std::endl;
  *pattern_stream << "63 60 " << std::endl;
  *pattern_stream << "63 61 " << std::endl;
  *pattern_stream << "63 62 " << std::endl;
  *pattern_stream << "64 16 " << std::endl;
  *pattern_stream << "64 17 " << std::endl;
  *pattern_stream << "64 28 " << std::endl;
  *pattern_stream << "64 29 " << std::endl;
  *pattern_stream << "64 30 " << std::endl;
  *pattern_stream << "64 31 " << std::endl;
  *pattern_stream << "64 32 " << std::endl;
  *pattern_stream << "64 42 " << std::endl;
  *pattern_stream << "64 43 " << std::endl;
  *pattern_stream << "64 44 " << std::endl;
  *pattern_stream << "64 45 " << std::endl;
  *pattern_stream << "64 46 " << std::endl;
  *pattern_stream << "64 47 " << std::endl;
  *pattern_stream << "64 61 " << std::endl;
  *pattern_stream << "64 62 " << std::endl;
  *pattern_stream << "64 63 " << std::endl;
  *pattern_stream << "65 7 " << std::endl;
  *pattern_stream << "65 16 " << std::endl;
  *pattern_stream << "65 17 " << std::endl;
  *pattern_stream << "65 18 " << std::endl;
  *pattern_stream << "65 29 " << std::endl;
  *pattern_stream << "65 30 " << std::endl;
  *pattern_stream << "65 31 " << std::endl;
  *pattern_stream << "65 32 " << std::endl;
  *pattern_stream << "65 43 " << std::endl;
  *pattern_stream << "65 44 " << std::endl;
  *pattern_stream << "65 45 " << std::endl;
  *pattern_stream << "65 46 " << std::endl;
  *pattern_stream << "65 47 " << std::endl;
  *pattern_stream << "65 48 " << std::endl;
  *pattern_stream << "65 62 " << std::endl;
  *pattern_stream << "65 63 " << std::endl;
  *pattern_stream << "65 64 " << std::endl;
}
}  // namespace brisk
