module StripSrcLocNote(stripSrcLocNotes, stripSrcLocNoteExp) where

import Util
import CoreSyn

stripSrcLocNotes :: [CoreBind] -> [CoreBind]
stripSrcLocNotes = map stripSrcLocNote

stripSrcLocNote :: CoreBind -> CoreBind
stripSrcLocNote (NonRec b e) = NonRec b (stripSrcLocNoteExp e)
stripSrcLocNote (Rec bs)     = Rec (mapSnd stripSrcLocNoteExp bs)

stripSrcLocNoteExp :: CoreExpr -> CoreExpr
stripSrcLocNoteExp e@(Var _) = e
stripSrcLocNoteExp e@(Lit _) = e
stripSrcLocNoteExp (App l r) = App (stripSrcLocNoteExp l) (stripSrcLocNoteExp r)
stripSrcLocNoteExp (Lam b e) = Lam b (stripSrcLocNoteExp e)
stripSrcLocNoteExp (Let b e) = Let (stripSrcLocNote b) (stripSrcLocNoteExp e)
stripSrcLocNoteExp (Case e b t as) = Case (stripSrcLocNoteExp e) b t 
                                          (map stripSrcLocNoteAlt as)
stripSrcLocNoteExp (Cast e c) = Cast (stripSrcLocNoteExp e) c
stripSrcLocNoteExp (Note (CoreSrcLoc _) e) = (stripSrcLocNoteExp e)   -- The only interesting case, blink and you'll miss it.
stripSrcLocNoteExp (Note n e) = Note n (stripSrcLocNoteExp e)
stripSrcLocNoteExp e@(Type _) = e

stripSrcLocNoteAlt :: CoreAlt -> CoreAlt
stripSrcLocNoteAlt (con, bs, e) = (con, bs, stripSrcLocNoteExp e)
