var minx = 0, maxx = 0, miny = 0, maxy = 0;
var w=925,h=250, margin = 10;
var xaxis;
var yaxis;
var margin = 0;
var vis;
var linecount = 0;
var linecolors = ["FFAAAA","CCCCCC","FFFF88","88FFFF","AAAAAAFF", "AAFFAA", "AAAAAA", "FF88FF", "EEEEEE", "BBFF88", "88FFBB"];
var origcolors = {};
var leaveon = {};
//Note that this has to match the value in the css file
var padding = 50;
var floatingdiv;

var mouseX;
var mouseY;

$(document).mousemove( function(e) {
   mouseX = e.pageX; 
   mouseY = e.pageY;
});

function setAxis (newxmin, newxmax, newymin, newymax) {
	minx = newxmin;
	maxx = newxmax;
	miny = newymin;
	maxy = newymax;
	
	margin = 25;
	
	yaxis=d3.scale.linear().domain([maxy,miny]).range([0+ margin,h- margin]);
	xaxis=d3.scale.linear().domain([minx,maxx]).range([0+ margin,w]);
}

function cleanData (sets, xvar, yvar, parentdiv) {
  vis=d3.select(parentdiv).append("svg:svg").attr("width",w).attr("height",h).append("svg:g");

  var line=d3.svg.line()
           .x(function(d,i){return xaxis(d.x);})
		   .y(function(d){return yaxis(d.y);});
  
  for (var ds in sets) {
	var currData=[];
	for (var z = 0; z < sets[ds].length; z++) {
	  if (typeof ((sets[ds])[z])[yvar] !== "undefined") {
	    currData.push({x:z,y:((sets[ds])[z])[yvar]});
	  }
	}
	if (!(ds in origcolors)) {
	  origcolors[ds] = linecolors[(linecount++)%linecolors.length];
	  leaveon[ds] = false;
	}
    vis.append("svg:path").data([currData]).attr("class",ds).attr("d",line).on("mouseover",onmouseover).on("mouseout",onmouseout).on("click",onmouseclick).style("stroke", "#" + origcolors[ds]).attr("stroke-width", 2).attr("fill", "none");
  }

  //x-axis line
  vis.append("svg:line").attr("x1",xaxis(minx)).attr("y1",yaxis(miny)).attr("x2",xaxis(maxx)).attr("y2",yaxis(miny)).attr("class","axis").style("stroke", "#000");

  //y-axis line
  vis.append("svg:line").attr("x1",xaxis(minx)).attr("y1",yaxis(maxy)).attr("x2",(minx+margin)).attr("y2",yaxis(miny)).attr("class","axis").style("stroke", "#000");

  //x-axis label
  vis.selectAll(".xLabel").data(xaxis.ticks(5)).enter().append("svg:text").attr("class","xLabel").text(String).attr("x",function(d){return xaxis(d)}).attr("y",h-10).attr("text-anchor","middle");

  //y-axis label
  vis.selectAll(".yLabel").data(yaxis.ticks(4)).enter().append("svg:text").attr("class","yLabel").text(String).attr("x",0).attr("y",function(d){return yaxis(d)}).attr("text-anchor","right").attr("dy",3);

  vis.selectAll(".xTicks").data(xaxis.ticks(5)).enter().append("svg:line").attr("class","xTicks").attr("x1",function(d){
	       return xaxis(d);
		 }).attr("y1",yaxis(miny)).attr("x2",function(d){
		   return xaxis(d);
		 }).attr("y2",yaxis(miny)+7);

  vis.selectAll(".yTicks").data(yaxis.ticks(4)).enter().append("svg:line").attr("class","yTicks").attr("y1",function(d){
	       return yaxis(d);
		 }).attr("x1",xaxis(minx-margin)).attr("y2",function(d){
		   return yaxis(d);
		 }).attr("x2",xaxis(minx));
}

function onmouseover(d,i){
  var currClass=d3.select(this).attr("class");
  var xval = xaxis.invert(d3.mouse(this)[0]);
  var yval = yaxis.invert(d3.mouse(this)[1]);
  d3.select(this).append("svg:title").text(function(d) { return currClass + ": (" + xval.toFixed(2) + "," + yval.toFixed(2) + ")"; });
  
  d3.selectAll("."+currClass).style("stroke", "#" + (parseInt(origcolors[currClass], 16) - parseInt("5A5A5A", 16)).toString(16));
}

function onmouseclick(d){
  var currClass=d3.select(this).attr("class");
  leaveon[currClass] = !leaveon[currClass];
}

function onmouseout(d,i){
  var currClass=d3.select(this).attr("class");
  if (!leaveon[currClass]) {
    d3.selectAll("."+currClass).style("stroke", "#"+origcolors[currClass]);
  }
}

