var datasets = {};
var variables = [];

function makeIterator(array){
    var nextIndex = 0;
    
    return {
       next: function(){
           return nextIndex < array.length ?
               {value: array[nextIndex++], done: false} :
               {done: true};
       }
    }
}

function addDataset(id, newset, headers) {
	//set default of having a header row to false
	headers = typeof headers !== 'undefined' ? headers : false;
	//TODO: check id and newset for validity/existence
	//TODO: check id for duplicates
	
    var setiterator = makeIterator(newset);
	var row = setiterator.next();
	if (row.done) { return; }
	if (headers) {
		setheaders = row.value.split(",");
		for (var x = 0; x < setheaders.length; x++) {
		  if (variables.lastIndexOf(setheaders[x]) == -1) {
			variables.push(setheaders[x]);
		  }
		}
		//TODO: check for duplicates and __INDEX__
		row = setiterator.next();
	} else {
		setheaders = new Array();
		for (var x = 0; x < row.value.split(",").length; x++) {
			setheaders.push(x);
			if (variables.lastIndexOf(x) == -1) {
				variables.push(x);
			}
		} 
	}
	
	var index = 0;
	var addset = new Array();
	
	while(!row.done) {
		var maprow = {};
		if (row.value.length == 0) { break; }
		if (row.value.split(",").length != setheaders.length) {
			//TODO: add exception
		}
		var splitrow = row.value.split(",");
		maprow["__INDEX__"] = index++;
		for (var x = 0; x < splitrow.length; x++) {
			maprow[setheaders[x]] = splitrow[x];
		}
		addset.push(maprow);
		row = setiterator.next();
	}
	
	datasets[id] = addset;
}

function populateradios(classid, nameid) {
	for (var x = 0; x < variables.length; x++) {
		$("#"+classid).append('<input type = "radio" name = "' + classid + 
		                  '" id = "' + nameid + variables[x] + '" value = "' +
						  variables[x] + '" /><label for = "' + nameid + 
						  variables[x] + '">' + variables[x] + '</label>');
	}
}

function populatedscheckboxes(classid, nameid) {
	for (var ds in datasets) {
		$("#"+classid).append('<input type = "checkbox" name = "box' + classid + 
		                  '" id = "box' + ds + '" value = "' + ds +
						  '" onclick = "setActiveSets()" ' + //' checked ' +
'						  /><label for = "box' + ds + 
						  '">' + ds + '</label>');
	}
}

function findMin(variable, sets) {
	headers = typeof sets !== 'undefined' ? sets : datasets;
	var min;
	for (var ds in datasets) {
	  for (var index = 0; index < datasets[ds].length; index++) {
		  if (variable in datasets[ds][index]) {
			  if (typeof min === "undefined") {
				  min = datasets[ds][index][variable];
			  } else if (parseFloat(datasets[ds][index][variable]) < parseFloat(min)) {
				  min = datasets[ds][index][variable];
			  }
		  }
	  }
	}
    return min;
}

function findMax(variable, sets) {
	headers = typeof sets !== 'undefined' ? sets : datasets;
	var max;
	for (var ds in datasets) {
	  for (var index = 0; index < datasets[ds].length; index++) {
		  if (variable in datasets[ds][index]) {
			  if (typeof max === "undefined") {
				  max = datasets[ds][index][variable];
			  } else if (parseFloat(datasets[ds][index][variable]) > parseFloat(max)) {
				  max = datasets[ds][index][variable];
			  }
		  }
	  }
	}
    return max*1.05;
}

function getSets(whichsets) {
	var tempsets = {};
	for (var x = 0; x < whichsets.length; x++) {
		tempsets[whichsets[x]] = datasets[whichsets[x]];
	}
	return tempsets;
}

